package com.centit.tablestore.service;

import com.alibaba.fastjson2.JSONArray;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectTeam;

import java.util.List;

public interface ProjectInfoService {

    void saveProjectInfo(ProjectInfo projectInfo);

    void updateProjectInfo(ProjectInfo projectInfo);

    void deleteProjectInfo(String projectId);

    ProjectInfo getProjectInfo(String projectId);

    JSONArray listUserProjects(String userCode, PageDesc pageDesc);

    JSONArray listUserCreateProjects(String userCode, PageDesc pageDesc);

    void addProjectMember(String optUser, String projectId, String memberCode);

    void deleteProjectMember(String optUser, String projectId, String memberCode);

    List<ProjectTeam> listProjectMember(String optUser, String projectId);

    ProjectInfo forkProject(String optUser, String projectId);

    String makeCreateSql(String projectId, DBType dbType);
}
