package com.centit.tablestore.po;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 项目模块
 */
@ApiModel
@Data
@Entity
@Table(name = "TS_PROJECT_MODULE")
public class ProjectModule implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "MODULE_ID")
    @ApiModelProperty(value = "模块ID")
    @ValueGenerator(strategy = GeneratorType.UUID22)
    private String moduleId;

    @Column(name = "PROJECT_ID")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @Column(name = "MODULE_NAME")
    @ApiModelProperty(value = "模块名称")
    private String moduleName;

    @Column(name = "MODULE_DESC")
    @ApiModelProperty(value = "模块描述")
    private String moduleDesc;

    @Column(name = "MODULE_DESIGN_JSON")
    @ApiModelProperty(value = "字段信息JSON")
    private JSONObject moduleDesign;

    @Column(name = "CREATOR_CODE")
    @ApiModelProperty(value = "模块创建人")
    @DictionaryMap(value="userCode", fieldName = "creatorName")
    private String creatorCode;

    @Column(name = "LAST_UPDATE_TIME")
    @ApiModelProperty(value = "最后更新时间")
    @ValueGenerator(strategy = GeneratorType.FUNCTION, condition = GeneratorCondition.ALWAYS, value = "today()")
    private Date lastUpdateTIme;

    public List<String> extraReferenceTables(String tableType) {
        List<String> tableIds = new ArrayList<>();
        if (tableType.indexOf('T') >= 0) {
            Object tables = moduleDesign.get("tables");
            if (tables instanceof List) {
                for (Object table : (List<Object>) tables) {
                    if (table instanceof Map) {
                        Map<String, Object> tableMap = (Map<String, Object>) table;
                        Object tableInfo = tableMap.get("info");
                        if (tableInfo instanceof Map) {
                            tableIds.add(
                                    StringBaseOpt.castObjectToString(((Map<String, Object>) tableInfo).get("tableId")));
                        }
                    }
                }
            }
        }

        if (tableType.indexOf('V') >= 0) {
            Object views = moduleDesign.get("views");
            if (views instanceof List) {
                for (Object view : (List<Object>) views) {
                    if (view instanceof Map) {
                        Map<String, Object> viewMap = (Map<String, Object>) view;
                        Object viewInfo = viewMap.get("info");
                        if (viewInfo instanceof Map) {
                            tableIds.add(
                                    StringBaseOpt.castObjectToString(((Map<String, Object>) viewInfo).get("viewId")));
                        }
                    }
                }
            }
        }
        return tableIds;
    }

}
