package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.ProjectTeamId;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class ProjectTeamDao extends BaseDaoImpl<ProjectTeam, ProjectTeamId> {

    @Override
    public Map<String, String> getFilterField() {
            return null;
    }

    public void deleteProjectTeam(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap("projectId", projectId));
    }

    public boolean checkMember(String projectId, String userCode){
        return NumberBaseOpt.castObjectToInteger(
                DatabaseOptUtils.getScalarObjectQuery( this,
                        "select count(1) as projectSum from TS_PROJECT_TEAM a " +
                                "where a.PROJECT_ID = ? and a.PROJECT_MEMBER = ?",
                        new Object[]{projectId, userCode}), 0) > 0;
    }
}
