/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.TableStructService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tableStructService")
@Transactional
public class TableStructServiceImpl
implements TableStructService {
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveTableStruct(TableStruct tableStruct) {
        this.tableStructDao.saveNewObject(tableStruct);
    }

    private List<SimpleTableField> findTableColumns(Map<String, List<SimpleTableField>> allTables, String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            if (allTables.size() == 1) {
                return allTables.values().iterator().next();
            }
            return null;
        }
        return allTables.get(tableName);
    }

    private SimpleTableField searchTableColumn(Map<String, List<SimpleTableField>> allTables, String tableName, String columnName) {
        List<SimpleTableField> columns = this.findTableColumns(allTables, tableName);
        if (columns != null) {
            return this.findTableColumn(columns, columnName);
        }
        for (List<SimpleTableField> cols : allTables.values()) {
            SimpleTableField column = this.findTableColumn(cols, columnName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    private SimpleTableField findTableColumn(List<SimpleTableField> columns, String columnName) {
        for (SimpleTableField column : columns) {
            if (!StringUtils.equals((CharSequence)columnName, (CharSequence)column.getColumnName())) continue;
            return column;
        }
        return null;
    }

    @Override
    public TableStruct updateViewSql(TableStruct tableStruct) {
        String viewSql = tableStruct.extraViewSql();
        List oldColumns = tableStruct.toTableInfo().getColumns();
        Pair viewQueryStruct = QueryUtils.extraFieldAndTable((String)viewSql);
        HashMap<String, List<SimpleTableField>> fromTables = new HashMap<String, List<SimpleTableField>>();
        for (Map.Entry table : ((Map)viewQueryStruct.getValue()).entrySet()) {
            TableStruct struct = this.tableStructDao.getTableByName(tableStruct.getProjectId(), (String)table.getKey());
            if (struct == null) continue;
            fromTables.put((String)table.getValue(), struct.toTableInfo().getColumns());
        }
        LinkedHashMap<Object, SimpleTableField> newColumns = new LinkedHashMap<Object, SimpleTableField>();
        for (Pair field : (List)viewQueryStruct.getKey()) {
            String fieldFormula;
            String tableName;
            String fileDesc = (String)field.getValue();
            int n = fileDesc.indexOf(46);
            if (n > 0) {
                tableName = fileDesc.substring(0, n).trim();
                fieldFormula = fileDesc.substring(n + 1).trim();
            } else {
                tableName = "";
                fieldFormula = fileDesc;
            }
            if ("*".equals(fieldFormula)) {
                List<SimpleTableField> tableColumns = this.findTableColumns(fromTables, tableName);
                for (SimpleTableField field1 : tableColumns) {
                    SimpleTableField oldViewCol = this.findTableColumn(oldColumns, field1.getColumnName());
                    SimpleTableField column = new SimpleTableField();
                    if (oldViewCol != null) {
                        BeanUtils.copyProperties((Object)oldViewCol, (Object)column);
                    } else {
                        BeanUtils.copyProperties((Object)field1, (Object)column);
                    }
                    newColumns.put(field1.getColumnName(), column);
                }
                continue;
            }
            SimpleTableField column = new SimpleTableField();
            SimpleTableField oldViewCol = this.findTableColumn(oldColumns, (String)field.getKey());
            if (oldViewCol != null) {
                BeanUtils.copyProperties((Object)oldViewCol, (Object)column);
            } else {
                SimpleTableField tempCol = this.searchTableColumn(fromTables, tableName, fieldFormula);
                if (tempCol != null) {
                    BeanUtils.copyProperties((Object)tempCol, (Object)column);
                }
            }
            column.setColumnName((String)field.getKey());
            column.setColumnComment(fileDesc);
            newColumns.put(field.getKey(), column);
        }
        tableStruct.setTableColumns(newColumns.values());
        this.tableStructDao.saveNewObject(tableStruct);
        return tableStruct;
    }

    @Override
    public void updateTableStruct(TableStruct tableStruct) {
        this.tableStructDao.updateObject(tableStruct);
    }

    @Override
    public void deleteTableStruct(String tableId) {
        this.tableStructDao.deleteObjectById(tableId);
    }

    @Override
    public TableStruct getTableStruct(String tableId) {
        return (TableStruct)this.tableStructDao.getObjectById(tableId);
    }

    @Override
    public TableStruct forkTable(String userCode, String tableId, String projectId) {
        if (!this.projectTeamDao.checkMember(projectId, userCode)) {
            throw new ObjectException("\u7528\u6237 " + userCode + " \u65e0\u6743\u64cd\u4f5c " + projectId + " \u9879\u76ee\u3002");
        }
        TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(tableId);
        ts.setTableId(UuidOpt.getUuidAsString22());
        ts.setProjectId(projectId);
        ts.setCreatorCode(userCode);
        this.tableStructDao.saveNewObject(ts);
        return ts;
    }

    @Override
    public List<TableStruct> listProjectTables(String projectId, Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("projectId", projectId);
        return this.tableStructDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public JSONArray statTables(String keyWord) {
        return this.tableStructDao.statTables(keyWord);
    }

    @Override
    public JSONArray searchTables(String keyWord, String industryCategory, PageDesc pageDesc) {
        return this.tableStructDao.searchTables(keyWord, industryCategory, pageDesc);
    }

    @Override
    public String makeCreateSql(String tableId, DBType dbType) {
        TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(tableId);
        if (ts == null) {
            return null;
        }
        return ts.buildCreateTableSql(dbType);
    }
}

