/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectModuleService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectModuleService")
@Transactional
public class ProjectModuleServiceImpl
implements ProjectModuleService {
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveProjectModule(ProjectModule projectModule) {
        this.projectModuleDao.saveNewObject(projectModule);
    }

    @Override
    public void updateProjectModule(ProjectModule projectModule) {
        this.projectModuleDao.updateObject(projectModule);
    }

    @Override
    public void deleteProjectModule(String moduleId) {
        this.projectModuleDao.deleteObjectById(moduleId);
    }

    @Override
    public ProjectModule getProjectModule(String moduleId) {
        return (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
    }

    @Override
    public List<ProjectModule> listProjectModules(String projectId) {
        return this.projectModuleDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    @Override
    public ProjectModule forkModule(String userCode, String moduleId, String projectId) {
        Object views;
        if (!this.projectTeamDao.checkMember(projectId, userCode)) {
            throw new ObjectException("\u7528\u6237 " + userCode + " \u65e0\u6743\u64cd\u4f5c " + projectId + " \u9879\u76ee\u3002");
        }
        ProjectModule pm = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        pm.setModuleId(UuidOpt.getUuidAsString22());
        pm.setProjectId(projectId);
        pm.setCreatorCode(userCode);
        Object tables = pm.getModuleDesign().get("tables");
        if (tables instanceof List) {
            for (Object table : (List)tables) {
                Map tableMap;
                Object tableInfo;
                if (!(table instanceof Map) || !((tableInfo = (tableMap = (Map)table).get("info")) instanceof JSONObject)) continue;
                String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)tableInfo).get("tableId"));
                String newTableId = UuidOpt.getUuidAsString22();
                TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(oldTalbeId);
                ts.setTableId(newTableId);
                ts.setProjectId(projectId);
                ts.setCreatorCode(userCode);
                this.tableStructDao.saveNewObject(ts);
                ((JSONObject)tableInfo).put((Object)"tableId", (Object)newTableId);
            }
        }
        if ((views = pm.getModuleDesign().get("views")) instanceof List) {
            for (Object view : (List)views) {
                Map viewMap;
                Object viewInfo;
                if (!(view instanceof Map) || !((viewInfo = (viewMap = (Map)view).get("info")) instanceof JSONObject)) continue;
                String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)viewInfo).get("viewId"));
                String newTableId = UuidOpt.getUuidAsString22();
                TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(oldTalbeId);
                ts.setTableId(newTableId);
                ts.setProjectId(projectId);
                ts.setCreatorCode(userCode);
                this.tableStructDao.saveNewObject(ts);
                ((JSONObject)viewInfo).put((Object)"viewId", (Object)newTableId);
            }
        }
        this.projectModuleDao.saveNewObject(pm);
        return pm;
    }

    @Override
    public String makeCreateSql(String moduleId, DBType dbType) {
        ProjectModule module = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        List<String> tables = module.extraReferenceTables("VT");
        StringBuilder sqlBuilder = new StringBuilder("/*==============================================================*/\n\n/* Created on:   ").append(DatetimeOpt.currentDatetime()).append("                        */\n\n/*==============================================================*/\r\n");
        if (tables != null) {
            for (String ts : tables) {
                TableStruct struct = (TableStruct)this.tableStructDao.getObjectById(ts);
                if (struct == null) continue;
                sqlBuilder.append(struct.buildCreateTableSql(dbType)).append("\r\n");
            }
        }
        return sqlBuilder.toString();
    }
}

