/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.ProjectTeamId;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectInfoService")
@Transactional
public class ProjectInfoServiceImpl
implements ProjectInfoService {
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.saveNewObject(projectInfo);
        this.projectTeamDao.saveNewObject(new ProjectTeam(projectInfo.getProjectId(), projectInfo.getCreatorCode()));
    }

    @Override
    public void updateProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.updateObject(projectInfo);
    }

    @Override
    public void deleteProjectInfo(String projectId) {
        this.projectInfoDao.deleteObjectById(projectId);
        this.projectModuleDao.deleteProjectModule(projectId);
        this.tableStructDao.deleteProjectTable(projectId);
        this.projectTeamDao.deleteProjectTeam(projectId);
    }

    @Override
    public ProjectInfo getProjectInfo(String projectId) {
        return (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
    }

    @Override
    public JSONArray listUserProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a join TS_PROJECT_TEAM b on(a.PROJECT_ID= b.PROJECT_ID) where b.PROJECT_MEMBER = ?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public JSONArray listUserCreateProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a where a.CREATOR_CODE=?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public void addProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        ProjectTeam pt = (ProjectTeam)this.projectTeamDao.getObjectById(new ProjectTeamId(projectId, memberCode));
        if (pt != null) {
            return;
        }
        this.projectTeamDao.saveNewObject(new ProjectTeam(projectId, memberCode));
    }

    @Override
    public void deleteProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        if (!optUser.equals(memberCode)) {
            this.projectTeamDao.deleteObjectById(new ProjectTeamId(projectId, memberCode));
        }
    }

    @Override
    public List<ProjectTeam> listProjectMember(String optUser, String projectId) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        return this.projectTeamDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    @Override
    public ProjectInfo forkProject(String optUser, String projectId) {
        List modules;
        ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
        if (projectInfo == null) {
            throw new ObjectException("\u9879\u76ee " + projectId + " \u4e0d\u5b58\u5728\u3002");
        }
        if (StringUtils.equals((CharSequence)optUser, (CharSequence)projectInfo.getCreatorCode())) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u80fdfork\u81ea\u5df1\u7684\u9879\u76ee\u3002");
        }
        ProjectInfo forkProject = (ProjectInfo)this.projectInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"creatorCode", optUser, "forkProject", projectId}));
        if (forkProject != null) {
            return forkProject;
        }
        forkProject = projectInfo;
        forkProject.setProjectId(UuidOpt.getUuidAsString22());
        forkProject.setForkProject(projectId);
        forkProject.setCreatorCode(optUser);
        this.saveProjectInfo(forkProject);
        HashMap<String, String> tableIdMap = new HashMap<String, String>(100);
        List tables = this.tableStructDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
        if (tables != null) {
            for (TableStruct ts : tables) {
                String newTableId = UuidOpt.getUuidAsString22();
                tableIdMap.put(ts.getTableId(), newTableId);
                ts.setTableId(newTableId);
                ts.setProjectId(forkProject.getProjectId());
                ts.setCreatorCode(optUser);
                this.tableStructDao.saveNewObject(ts);
            }
        }
        if ((modules = this.projectModuleDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}))) != null) {
            for (ProjectModule pm : modules) {
                Object views;
                pm.setModuleId(UuidOpt.getUuidAsString22());
                pm.setProjectId(forkProject.getProjectId());
                pm.setCreatorCode(optUser);
                Object moduleTables = pm.getModuleDesign().get("tables");
                if (moduleTables instanceof List) {
                    for (Object table : (List)moduleTables) {
                        Map tableMap;
                        Object tableInfo;
                        if (!(table instanceof Map) || !((tableInfo = (tableMap = (Map)table).get("info")) instanceof JSONObject)) continue;
                        String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)tableInfo).get("tableId"));
                        String newTableId = (String)tableIdMap.get(oldTalbeId);
                        if (newTableId == null) {
                            newTableId = "";
                        }
                        ((JSONObject)tableInfo).put((Object)"tableId", (Object)newTableId);
                    }
                }
                if ((views = pm.getModuleDesign().get("views")) instanceof List) {
                    for (Object view : (List)views) {
                        Map viewMap;
                        Object viewInfo;
                        if (!(view instanceof Map) || !((viewInfo = (viewMap = (Map)view).get("info")) instanceof JSONObject)) continue;
                        String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)viewInfo).get("viewId"));
                        String newTableId = (String)tableIdMap.get(oldTalbeId);
                        if (newTableId == null) {
                            newTableId = "";
                        }
                        ((JSONObject)viewInfo).put((Object)"viewId", (Object)newTableId);
                    }
                }
                this.projectModuleDao.saveNewObject(pm);
            }
        }
        return forkProject;
    }

    @Override
    public String makeCreateSql(String projectId, DBType dbType) {
        StringBuilder sqlBuilder = new StringBuilder("/*==============================================================*/\n\n/* Created on:   ").append(DatetimeOpt.currentDatetime()).append("                        */\n\n/*==============================================================*/\r\n");
        List tables = this.tableStructDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
        if (tables != null) {
            for (TableStruct ts : tables) {
                sqlBuilder.append(ts.buildCreateTableSql(dbType)).append("\r\n");
            }
        }
        return sqlBuilder.toString();
    }
}

