/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DBType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="TS_TABLE_STRUCT")
public class TableStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="TABLE_ID")
    @ApiModelProperty(value="\u8868ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String tableId;
    @Column(name="PROJECT_ID")
    @ApiModelProperty(value="\u9879\u76eeID")
    private String projectId;
    @Column(name="TABLE_TYPE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[TVC]")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u7c7b\u522b\uff08T-\u8868\uff1bV-\u89c6\u56fe\uff1bC-\u5927\u5b57\u6bb5\uff09")
    @DictionaryMap(fieldName={"tableTypeText"}, value={"TableType"})
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[TVC]") @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableType;
    @Column(name="TABLE_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u540d")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableName;
    @Column(name="TABLE_LABEL_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u4e2d\u6587\u540d")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableLabelName;
    @ApiModelProperty(value="\u8868\u63cf\u8ff0")
    @Column(name="TABLE_COMMENT")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableComment;
    @Column(name="CREATOR_CODE")
    @ApiModelProperty(value="\u9879\u76ee\u521b\u5efa\u4eba")
    @DictionaryMap(value={"userCode"}, fieldName={"creatorName"})
    private String creatorCode;
    @Column(name="LAST_UPDATE_TIME")
    @ApiModelProperty(value="\u6700\u540e\u66f4\u65b0\u65f6\u95f4")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastUpdateTIme;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="COLUMN_FIELD_JSON")
    @ApiModelProperty(value="\u5b57\u6bb5\u4fe1\u606fJSON")
    private JSONObject metadataJson;
    @Column(name="FULLTEXT_INDEX")
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize=false, deserialize=false)
    @ApiModelProperty(value="\u5168\u6587\u68c0\u7d22\u5b57\u6bb5")
    private String fulltextIndex;
    @Column(name="VIEW_TIMES")
    @ApiModelProperty(value="\u88ab\u67e5\u770b\u6b21\u6570\uff0c\u590d\u5236sql\u8bed\u53e5\u3001\u5bfc\u51fa\u89c6\u4e3a\u6709\u6548\u67e5\u770b")
    private String viewTimes;

    public String getFulltextIndex() {
        StringBuilder textBuilder = new StringBuilder(this.tableName).append(" ").append(this.tableLabelName).append(" ").append(this.tableComment).append(";");
        Object columns = this.metadataJson.get("columns");
        if (columns instanceof List) {
            for (Object col : (List)columns) {
                if (!(col instanceof Map)) continue;
                Map colMap = (Map)col;
                textBuilder.append(" ").append(colMap.get("columnName")).append(" ").append(colMap.get("fieldLabelName")).append(" ").append(colMap.get("columnComment")).append(";");
            }
        }
        this.fulltextIndex = textBuilder.toString();
        return this.fulltextIndex;
    }

    public String extraViewSql() {
        return StringBaseOpt.castObjectToString((Object)this.metadataJson.get("viewSql"));
    }

    public SimpleTableInfo toTableInfo() {
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        tableInfo.setTableName(this.tableName);
        tableInfo.setTableLabelName(this.tableLabelName);
        tableInfo.setTableComment(this.tableComment);
        tableInfo.setTableType(this.tableType);
        Object columns = this.metadataJson.get("columns");
        if (columns instanceof List) {
            for (Object col : (List)columns) {
                if (!(col instanceof Map)) continue;
                SimpleTableField column = new SimpleTableField();
                Map colMap = (Map)col;
                column.setColumnName(StringBaseOpt.castObjectToString(colMap.get("columnName")));
                column.setFieldLabelName(StringBaseOpt.castObjectToString(colMap.get("fieldLabelName")));
                column.setColumnComment(StringBaseOpt.castObjectToString(colMap.get("columnComment")));
                column.setColumnType(StringBaseOpt.castObjectToString(colMap.get("columnType")));
                column.setMandatory(BooleanBaseOpt.castObjectToBoolean(colMap.get("columnType"), (Boolean)false).booleanValue());
                column.setFieldType(StringBaseOpt.castObjectToString(colMap.get("fieldType")));
                column.setMaxLength(NumberBaseOpt.castObjectToInteger(colMap.get("maxLength")).intValue());
                column.setScale(NumberBaseOpt.castObjectToInteger(colMap.get("scale")));
                column.setPrimaryKey(BooleanBaseOpt.castObjectToBoolean(colMap.get("primaryKey"), (Boolean)false).booleanValue());
                column.setPrecision(NumberBaseOpt.castObjectToInteger(colMap.get("maxLength")));
                tableInfo.addColumn(column);
            }
        }
        return tableInfo;
    }

    public void setTableColumns(Collection<SimpleTableField> columns) {
        this.metadataJson.put((Object)"columns", JSON.toJSON(columns));
    }

    public String buildCreateTableSql(DBType dbType) {
        try {
            if ("V".equals(this.getTableType())) {
                return "create View " + this.getTableName() + " " + this.extraViewSql() + ";";
            }
            return GeneralDDLOperations.createDDLOperations((DBType)dbType).makeCreateTableSql((TableInfo)this.toTableInfo());
        }
        catch (SQLException sqlExp) {
            return "/** \u521b\u5efa\u8868\uff1a" + this.getTableLabelName() + "(" + this.getTableName() + ")\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + sqlExp.getMessage() + "*/";
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String tableLabelName) {
        this.tableLabelName = tableLabelName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public String getCreatorCode() {
        return this.creatorCode;
    }

    public void setCreatorCode(String creatorCode) {
        this.creatorCode = creatorCode;
    }

    public Date getLastUpdateTIme() {
        return this.lastUpdateTIme;
    }

    public void setLastUpdateTIme(Date lastUpdateTIme) {
        this.lastUpdateTIme = lastUpdateTIme;
    }

    public JSONObject getMetadataJson() {
        return this.metadataJson;
    }

    public void setMetadataJson(JSONObject metadataJson) {
        this.metadataJson = metadataJson;
    }

    public String getViewTimes() {
        return this.viewTimes;
    }

    public void setViewTimes(String viewTimes) {
        this.viewTimes = viewTimes;
    }
}

