/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.TableStruct;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TableStructDao
extends BaseDaoImpl<TableStruct, String> {
    public Map<String, String> getFilterField() {
        return null;
    }

    public JSONArray statTables(String keyWords) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)"select a.INDUSTRY_CATEGORY, count(1) as TABLE_SUM from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID where match(FULLTEXT_INDEX) against(?) group by a.INDUSTRY_CATEGORY", (Object[])new Object[]{keyWords});
    }

    public JSONArray searchTables(String keyWords, String industryCategory, PageDesc pageDesc) {
        int returnObject;
        int offset = pageDesc.getRowStart();
        int maxsize = pageDesc.getPageSize();
        String sql = "select b.TABLE_ID, b.PROJECT_ID, b.TABLE_TYPE, b.TABLE_NAME, b.TABLE_LABEL_NAME, b.TABLE_COMMENT, b.CREATOR_CODE, b.LAST_UPDATE_TIME from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID where match(FULLTEXT_INDEX) against(?) ";
        String limitSql = offset > 0 ? " limit " + offset + "," + maxsize : " limit " + maxsize;
        JSONArray jsonArray = null;
        jsonArray = StringUtils.isBlank((CharSequence)industryCategory) ? DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)(sql + limitSql), (Object[])new Object[]{keyWords}) : DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)(sql + " and a.INDUSTRY_CATEGORY = ?" + limitSql), (Object[])new Object[]{keyWords, industryCategory});
        int n = returnObject = jsonArray == null ? 0 : jsonArray.size();
        if (returnObject < maxsize) {
            pageDesc.setTotalRows(Integer.valueOf(offset + returnObject));
        } else if (offset + returnObject + 1 > pageDesc.getTotalRows()) {
            pageDesc.setTotalRows(Integer.valueOf(offset + returnObject + 1));
        }
        return jsonArray;
    }

    public void deleteProjectTable(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    public TableStruct getTableByName(String projectId, String tableName) {
        return (TableStruct)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId, "tableName", tableName}));
    }
}

