/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.service.ProjectInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9879\u76ee\u7ef4\u62a4\u63a5\u53e3", tags={"\u9879\u76ee\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"project"})
public class ProjectController
extends BaseController {
    @Autowired
    protected ProjectInfoService projectInfoService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="onlyCreated", value="\u4ec5\u4ec5\u8fd4\u56de\u7528\u6237\u521b\u5efa\u7684\u9879\u76ee", paramType="query"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801\uff0c\u4f18\u5148\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4ee3\u7801", paramType="query")})
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, String onlyCreated, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = request.getParameter("userCode");
        }
        JSONArray projectInfos = BooleanBaseOpt.castObjectToBoolean((Object)onlyCreated, (Boolean)false) != false ? this.projectInfoService.listUserCreateProjects(userCode, pageDesc) : this.projectInfoService.listUserProjects(userCode, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)projectInfos, (PageDesc)pageDesc, (Class[])new Class[]{ProjectInfo.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectInfo getProjectInfo(@PathVariable String projectId) {
        return this.projectInfoService.getProjectInfo(projectId);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @DeleteMapping(value={"/{projectId}"})
    @WrapUpResponseBody
    public void deleteProjectInfo(@PathVariable String projectId) {
        this.projectInfoService.deleteProjectInfo(projectId);
    }

    @ApiOperation(value="\u65b0\u5efa\u9879\u76ee\u6570\u636e")
    @PostMapping
    @WrapUpResponseBody
    public void saveProjectInfo(@RequestBody ProjectInfo projectInfo) {
        this.projectInfoService.saveProjectInfo(projectInfo);
    }

    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u6570\u636e")
    @PutMapping
    @WrapUpResponseBody
    public void updateProjectInfo(@RequestBody ProjectInfo projectInfo) {
        this.projectInfoService.updateProjectInfo(projectInfo);
    }

    @ApiOperation(value="\u751f\u6210\u811a\u672c", notes="\u751f\u6210\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/sql/{projectId}"})
    @WrapUpResponseBody
    public String createSql(@PathVariable String projectId, String dbtype) {
        return this.projectInfoService.makeCreateSql(projectId, DBType.mapDBType((String)dbtype));
    }

    @ApiOperation(value="fork\u9879\u76ee\u6570\u636e")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @PostMapping(value={"/fork/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectInfo forkProjectInfo(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.projectInfoService.forkProject(userCode, projectId);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/member/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<ProjectTeam> listProjectMember(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.projectInfoService.listProjectMember(userCode, projectId);
    }

    @ApiOperation(value="\u6dfb\u52a0\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @PostMapping(value={"/member"})
    @WrapUpResponseBody
    public void addProjectMember(@RequestBody ProjectTeam projectTeam, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        this.projectInfoService.addProjectMember(userCode, projectTeam.getProjectId(), projectTeam.getProjectMember());
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID"), @ApiImplicitParam(name="memberCode", type="path", value="\u534f\u4f5c\u4eba\u5458\u4ee3\u7801")})
    @GetMapping(value={"/delete/{projectId}/{memberCode}"})
    @WrapUpResponseBody
    public void deleteProjectMember(@PathVariable String projectId, @PathVariable String memberCode, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        this.projectInfoService.deleteProjectMember(userCode, projectId, memberCode);
    }
}

