package com.centit.tablestore.service;

import com.alibaba.fastjson.JSONArray;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.TableStruct;

import java.util.List;
import java.util.Map;

public interface TableStructService {
    void saveTableStruct(TableStruct tableStruct);

    TableStruct updateViewSql(TableStruct tableStruct);

    void updateTableStruct(TableStruct tableStruct);

    void deleteTableStruct(String tableId);

    String makeCreateSql(String tableId, DBType dbType);

    TableStruct getTableStruct(String tableId);

    TableStruct forkTable(String userCode, String tableId, String projectId);

    List<TableStruct> listProjectTables(String projectId, Map<String, Object> filterMap, PageDesc pageDesc);

    JSONArray statTables(String keyWord);

    JSONArray searchTables(String keyWord, String industryCategory, PageDesc pageDesc);
}
