/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.ProjectTeamId;
import com.centit.tablestore.service.ProjectInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectInfoService")
@Transactional
public class ProjectInfoServiceImpl
implements ProjectInfoService {
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.saveNewObject(projectInfo);
        this.projectTeamDao.saveNewObject(new ProjectTeam(projectInfo.getCreatorCode(), projectInfo.getCreatorCode()));
    }

    @Override
    public void updateProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.updateObject(projectInfo);
    }

    @Override
    public void deleteProjectInfo(String projectId) {
        this.projectInfoDao.deleteObjectById(projectId);
        this.projectModuleDao.deleteProjectModule(projectId);
        this.tableStructDao.deleteProjectTable(projectId);
        this.projectTeamDao.deleteProjectTeam(projectId);
    }

    @Override
    public ProjectInfo getProjectInfo(String projectId) {
        return (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
    }

    @Override
    public JSONArray listUserProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a join TS_PROJECT_TEAM b on(a.PROJECT_ID= b.PROJECT_ID) where b.PROJECT_MEMBER = ?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public JSONArray listUserCreateProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a where a.CREATOR_CODE=?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public void addProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        ProjectTeam pt = (ProjectTeam)this.projectTeamDao.getObjectById(new ProjectTeamId(projectId, memberCode));
        if (pt != null) {
            return;
        }
        this.projectTeamDao.saveNewObject(new ProjectTeam(projectId, memberCode));
    }

    @Override
    public void deleteProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        if (!optUser.equals(memberCode)) {
            this.projectTeamDao.deleteObjectById(new ProjectTeamId(projectId, memberCode));
        }
    }

    @Override
    public List<ProjectTeam> listProjectMember(String optUser, String projectId) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        return this.projectTeamDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    @Override
    public ProjectInfo forkProject(String optUser, String projectId) {
        ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
        if (projectInfo == null) {
            throw new ObjectException("\u9879\u76ee " + projectId + " \u4e0d\u5b58\u5728\u3002");
        }
        if (StringUtils.equals((CharSequence)optUser, (CharSequence)projectInfo.getCreatorCode())) {
            throw new ObjectException("\u7528\u6237 " + optUser + " \u4e0d\u80fdfork\u81ea\u5df1\u7684\u9879\u76ee\u3002");
        }
        ProjectInfo forkProject = (ProjectInfo)this.projectInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"creatorCode", optUser, "forkProject", projectId}));
        if (forkProject != null) {
            return forkProject;
        }
        forkProject = new ProjectInfo();
        forkProject.setForkProject(projectId);
        forkProject.setCreatorCode(optUser);
        return forkProject;
    }

    @Override
    public String makeCreateSql(String projectId, DBType dbType) {
        return null;
    }
}

