/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="TS_TABLE_STRUCT")
public class TableStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="TABLE_ID")
    @ApiModelProperty(value="\u8868ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String tableId;
    @Column(name="PROJECT_ID")
    @ApiModelProperty(value="\u9879\u76eeID")
    private String projectId;
    @Column(name="TABLE_TYPE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[TVC]")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u7c7b\u522b\uff08T-\u8868\uff1bV-\u89c6\u56fe\uff1bC-\u5927\u5b57\u6bb5\uff09")
    @DictionaryMap(fieldName={"tableTypeText"}, value={"TableType"})
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[TVC]") @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableType;
    @Column(name="TABLE_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u540d")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableName;
    @Column(name="TABLE_LABEL_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u4e2d\u6587\u540d")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableLabelName;
    @ApiModelProperty(value="\u8868\u63cf\u8ff0")
    @Column(name="TABLE_COMMENT")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableComment;
    @Column(name="CREATOR_CODE")
    @ApiModelProperty(value="\u9879\u76ee\u521b\u5efa\u4eba")
    @DictionaryMap(value={"userCode"}, fieldName={"creatorName"})
    private String creatorCode;
    @Column(name="LAST_UPDATE_TIME")
    @ApiModelProperty(value="\u6700\u540e\u66f4\u65b0\u65f6\u95f4")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastUpdateTIme;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="COLUMN_FIELD_JSON")
    @ApiModelProperty(value="\u5b57\u6bb5\u4fe1\u606fJSON")
    private JSONObject columnFields;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="VIEW_SQL")
    @ApiModelProperty(value="\u8bd5\u56feSelect\u8bed\u53e5")
    private String viewSql;
    @Column(name="FULLTEXT_INDEX")
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize=false, deserialize=false)
    @ApiModelProperty(value="\u5168\u6587\u68c0\u7d22\u5b57\u6bb5")
    private String fulltextIndex;
    @Column(name="VIEW_TIMES")
    @ApiModelProperty(value="\u88ab\u67e5\u770b\u6b21\u6570\uff0c\u590d\u5236sql\u8bed\u53e5\u3001\u5bfc\u51fa\u89c6\u4e3a\u6709\u6548\u67e5\u770b")
    private String viewTimes;

    public String getFulltextIndex() {
        StringBuilder textBuilder = new StringBuilder(this.tableName).append(" ").append(this.tableLabelName).append(" ").append(this.tableComment).append(";");
        Object columns = this.columnFields.get((Object)"columns");
        if (columns instanceof List) {
            for (Object col : (List)columns) {
                if (!(col instanceof Map)) continue;
                Map colMap = (Map)col;
                textBuilder.append(" ").append(colMap.get("columnName")).append(" ").append(colMap.get("fieldLabelName")).append(" ").append(colMap.get("columnComment")).append(";");
            }
        }
        this.fulltextIndex = textBuilder.toString();
        return this.fulltextIndex;
    }

    public TableInfo toTableInfo() {
        return null;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String tableLabelName) {
        this.tableLabelName = tableLabelName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public String getCreatorCode() {
        return this.creatorCode;
    }

    public void setCreatorCode(String creatorCode) {
        this.creatorCode = creatorCode;
    }

    public Date getLastUpdateTIme() {
        return this.lastUpdateTIme;
    }

    public void setLastUpdateTIme(Date lastUpdateTIme) {
        this.lastUpdateTIme = lastUpdateTIme;
    }

    public JSONObject getColumnFields() {
        return this.columnFields;
    }

    public void setColumnFields(JSONObject columnFields) {
        this.columnFields = columnFields;
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    public String getViewTimes() {
        return this.viewTimes;
    }

    public void setViewTimes(String viewTimes) {
        this.viewTimes = viewTimes;
    }
}

