/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.dao.RmdbOptLogDao;
import com.centit.framework.system.po.RmdbOptLog;
import com.centit.framework.system.service.OperationLogManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="optLogManager")
public class RmdbOptLogManager
implements OperationLogManager {
    private RmdbOptLogDao optLogDao;

    @Autowired
    @NotNull
    public void setOptLogDao(RmdbOptLogDao optLogDao) {
        this.optLogDao = optLogDao;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int delete(String begin) {
        return this.optLogDao.delete(begin);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteMany(String[] logIds) {
        for (String logId : logIds) {
            this.optLogDao.deleteObjectById(logId);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listOptLogsAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.mapJsonArray((JSONArray)this.optLogDao.listObjectsPartFieldByPropertiesAsJson(filterMap, CollectionsOpt.arrayToList((Object[])fields), pageDesc), (Class[])new Class[]{RmdbOptLog.class});
    }

    @Transactional
    public OperationLog getOptLogById(String logId) {
        RmdbOptLog rmdbOptLog = this.optLogDao.getObjectById(logId);
        return rmdbOptLog.toOperationLog();
    }

    @Transactional
    public void deleteOptLogById(String logId) {
        this.optLogDao.deleteObjectById(logId);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(OperationLog optLog) {
        if (StringUtils.isBlank((CharSequence)optLog.getTopUnit())) {
            return;
        }
        this.optLogDao.saveNewObject(RmdbOptLog.valueOf(optLog));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(List<OperationLog> optLogs) {
        for (OperationLog optlog : optLogs) {
            if (StringUtils.isBlank((CharSequence)optlog.getTopUnit())) continue;
            this.optLogDao.saveNewObject(RmdbOptLog.valueOf(optlog));
        }
    }

    public List<OperationLog> listOptLog(String optId, Map<String, Object> filterMap, int startPos, int maxRows) {
        List optlogs;
        if (!StringBaseOpt.isNvl((String)optId)) {
            filterMap.put("optId", optId);
        }
        List list = optlogs = startPos >= 0 && maxRows > 0 ? this.optLogDao.listObjectsByProperties(filterMap, new PageDesc(startPos, maxRows)) : this.optLogDao.listObjectsByProperties(filterMap);
        if (optlogs == null || optlogs.size() == 0) {
            return null;
        }
        return optlogs.stream().map(RmdbOptLog::toOperationLog).collect(Collectors.toList());
    }

    public int countOptLog(String optId, Map<String, Object> filterMap) {
        if (!StringBaseOpt.isNvl((String)optId)) {
            filterMap.put("optId", optId);
        }
        return this.optLogDao.countObjectByProperties(filterMap);
    }
}

