/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.OptLog;
import com.centit.framework.system.service.OptLogManager;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u7cfb\u7edf\u65e5\u5fd7\u7ef4\u62a4\u63a5\u53e3", tags={"\u7cfb\u7edf\u65e5\u5fd7\u64cd\u4f5c\u63a5\u53e3"})
@RequestMapping(value={"/optlog"})
public class OptLogController
extends BaseController {
    @Autowired
    @NotNull
    private OptLogManager optLogManager;

    public String getOptId() {
        return "OPTLOG";
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868", notes="\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="query", dataTypeClass=PageDesc.class)})
    @GetMapping
    @WrapUpResponseBody
    public ResponseMapData list(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray jsonArray = this.optLogManager.listOptLogsAsJson(field, searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jsonArray);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        resData.addResponseData("ORDER_BY", searchColumn.get("ORDER_BY"));
        return resData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u65e5\u5fd7", notes="\u6839\u636e\u65e5\u5fd7id\u67e5\u8be2\u5355\u6761\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7id", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getOptLogById(@PathVariable String logId) {
        OptLog dbOptLog = this.optLogManager.getOptLogById(logId);
        if (null == dbOptLog) {
            return ResponseData.makeErrorMessage((String)"\u65e5\u5fd7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return ResponseData.makeResponseData((Object)DictionaryMapUtils.objectToJSON((Object)dbOptLog));
    }

    @ApiOperation(value="\u5220\u9664\u5355\u6761\u7cfb\u7edf\u65e5\u5fd7", notes="\u6839\u636e\u65e5\u5fd7id\u5220\u9664\u5355\u6761\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7id", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteOne(@PathVariable String logId) {
        this.optLogManager.deleteOptLogById(logId);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u591a\u6761\u7cfb\u7edf\u65e5\u5fd7", notes="\u5220\u9664\u591a\u6761\u7cfb\u7edf\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logIds", value="\u6570\u7ec4\u683c\u5f0f\uff0c\u591a\u4e2a\u65e5\u5fd7ID", required=true, allowMultiple=true, paramType="query", dataType="String")
    @RequestMapping(value={"/deleteMany"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteMany(String[] logIds) {
        this.optLogManager.deleteMany(logIds);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u67d0\u65f6\u6bb5\u4e4b\u524d\u7684\u7cfb\u7edf\u65e5\u5fd7", notes="\u5220\u9664\u67d0\u65f6\u6bb5\u4e4b\u524d\u7684\u7cfb\u7edf\u65e5\u5fd7\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="begin", value="\u5f00\u59cb\u65f6\u95f4\u70b9(\u53c2\u6570\u4e3a\u65f6\u95f4\u8fd8\u672a\u5b9e\u73b0)", paramType="query", dataType="Date"), @ApiImplicitParam(name="end", value="\u7ed3\u675f\u65f6\u95f4\u70b9", paramType="query", dataTypeClass=Date.class)})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteByTime(Date begin, Date end) {
        this.optLogManager.delete(begin, end);
        return ResponseData.successResponse;
    }

    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public void saveOne(@RequestBody OptLog optLog) {
        this.optLogManager.saveOptLog(optLog);
    }

    @RequestMapping(value={"/saveMany"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void saveMany(@RequestBody String optLogJsonArray) {
        List optlogs = JSONArray.parseArray((String)optLogJsonArray, OptLog.class);
        this.optLogManager.saveBatchOptLogs(optlogs);
    }

    @ApiOperation(value="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7", notes="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u7cfb\u7edf\u540d", allowMultiple=true, paramType="path", dataType="String"), @ApiImplicitParam(name="startPos", value="\u67e5\u8be2\u8d77\u59cb\u4f4d\u7f6eoffset", paramType="query", dataTypeClass=Integer.class), @ApiImplicitParam(name="maxSize", value="\u8fd4\u56de\u6761\u6570", paramType="query", dataTypeClass=Integer.class)})
    @GetMapping(value={"/query/{optId}"})
    @WrapUpResponseBody
    public List<? extends OperationLog> queryOptlog(String optId, Integer startPos, Integer maxSize, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.optLogManager.listOptLog(optId, searchColumn, startPos, maxSize);
    }

    @ApiOperation(value="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7", notes="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u7cfb\u7edf\u540d", allowMultiple=true, paramType="path", dataType="String")
    @GetMapping(value={"/count/{optId}"})
    @WrapUpResponseBody
    public Integer countOptlog(String optId, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.optLogManager.countOptLog(optId, searchColumn);
    }
}

