/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.OperationLogManager;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u7cfb\u7edf\u65e5\u5fd7\u7ef4\u62a4\u63a5\u53e3", tags={"\u7cfb\u7edf\u65e5\u5fd7\u64cd\u4f5c\u63a5\u53e3"})
@RequestMapping(value={"/optlog", "/elkoptlog"})
public class OptLogController
extends BaseController {
    @Autowired
    @NotNull
    private OperationLogManager operationLogManager;
    @Autowired(required=false)
    private ESSearcher elkOptLogSearcher;

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868", notes="\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="query", dataTypeClass=PageDesc.class)})
    @GetMapping
    @WrapUpResponseBody
    public ResponseMapData list(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray jsonArray = this.operationLogManager.listOptLogsAsJson(field, searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jsonArray);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        resData.addResponseData("ORDER_BY", searchColumn.get("ORDER_BY"));
        return resData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u65e5\u5fd7", notes="\u6839\u636e\u65e5\u5fd7id\u67e5\u8be2\u5355\u6761\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7id", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getOptLogById(@PathVariable String logId) {
        OperationLog operationLog = this.operationLogManager.getOptLogById(logId);
        if (null == operationLog) {
            return ResponseData.makeErrorMessage((String)"\u65e5\u5fd7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return ResponseData.makeResponseData((Object)DictionaryMapUtils.objectToJSON((Object)operationLog));
    }

    @ApiOperation(value="\u5220\u9664\u5355\u6761\u7cfb\u7edf\u65e5\u5fd7", notes="\u6839\u636e\u65e5\u5fd7id\u5220\u9664\u5355\u6761\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7id", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteOne(@PathVariable String logId) {
        this.operationLogManager.deleteOptLogById(logId);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u591a\u6761\u7cfb\u7edf\u65e5\u5fd7", notes="\u5220\u9664\u591a\u6761\u7cfb\u7edf\u65e5\u5fd7\u3002")
    @ApiImplicitParam(name="logIds", value="\u6570\u7ec4\u683c\u5f0f\uff0c\u591a\u4e2a\u65e5\u5fd7ID", required=true, allowMultiple=true, paramType="query", dataType="String")
    @RequestMapping(value={"/deleteMany"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteMany(String[] logIds) {
        this.operationLogManager.deleteMany(logIds);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u67d0\u65f6\u6bb5\u4e4b\u524d\u7684\u7cfb\u7edf\u65e5\u5fd7", notes="\u5220\u9664\u67d0\u65f6\u6bb5\u4e4b\u524d\u7684\u7cfb\u7edf\u65e5\u5fd7\u3002")
    @RequestMapping(value={"/delete/{beginDate}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData deleteByTime(@PathVariable String beginDate) {
        if (StringBaseOpt.isNvl((String)beginDate)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u6307\u5b9a\u5177\u4f53\u7684\u5220\u9664\u65f6\u95f4\u8303\u56f4\uff01");
        }
        int delete = this.operationLogManager.delete(beginDate);
        return ResponseData.makeSuccessResponse((String)StringBaseOpt.castObjectToString((Object)delete));
    }

    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public void saveOne(@RequestBody OperationLog optLog) {
        this.operationLogManager.saveOptLog(optLog);
    }

    @RequestMapping(value={"/saveMany"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void saveMany(@RequestBody String optLogJsonArray) {
        List optlogs = JSONArray.parseArray((String)optLogJsonArray, OperationLog.class);
        this.operationLogManager.saveBatchOptLogs(optlogs);
    }

    @ApiOperation(value="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7", notes="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u7cfb\u7edf\u540d", allowMultiple=true, paramType="path", dataType="String"), @ApiImplicitParam(name="startPos", value="\u67e5\u8be2\u8d77\u59cb\u4f4d\u7f6eoffset", paramType="query", dataTypeClass=Integer.class), @ApiImplicitParam(name="maxSize", value="\u8fd4\u56de\u6761\u6570", paramType="query", dataTypeClass=Integer.class)})
    @GetMapping(value={"/query/{optId}"})
    @WrapUpResponseBody
    public List<? extends OperationLog> queryOptlog(@PathVariable String optId, Integer startPos, Integer maxSize, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.remove("startPos");
        searchColumn.remove("maxSize");
        return this.operationLogManager.listOptLog(optId, searchColumn, startPos.intValue(), maxSize.intValue());
    }

    @ApiOperation(value="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7\u6761\u6570", notes="\u6309\u5e94\u7528\u67e5\u8be2\u65e5\u5fd7\u6761\u6570\u3002")
    @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u7cfb\u7edf\u540d", allowMultiple=true, paramType="path", dataType="String")
    @GetMapping(value={"/count/{optId}"})
    @WrapUpResponseBody
    public Integer countOptlog(String optId, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.operationLogManager.countOptLog(optId, searchColumn);
    }

    @ApiOperation(value="\u7cbe\u786e\u67e5\u8be2\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/listES/{map}/{value}/{queryWord}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEs(String map, String value, String queryWord, PageDesc pageDesc) {
        Pair res = this.elkOptLogSearcher.search(CollectionsOpt.createHashMap((Object[])new Object[]{map, value}), queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u65e5\u5fd7\u4fe1\u606f\uff08\u4e0d\u586b\u5173\u952e\u5b57\u9ed8\u8ba4\u67e5\u8be2\u5168\u90e8\uff09")
    @RequestMapping(value={"/listESall"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEsAll(String queryWord, PageDesc pageDesc) {
        Pair res = this.elkOptLogSearcher.search(queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }
}

