define(['jquery', 'core/core', 'core/utils', 'config', 'plugins/mustache.min', 'core/cache', 'core/cache.dictionary', 'easyUI'],
function ($, Core, Utils, Config, Mustache, Cache, DictionaryCache) {
    function getRows(target) {
        var state = $(target).data('datagrid');
        if (state.filterSource) {
            return state.filterSource.rows;
        } else {
            return state.data.rows;
        }
    }
    //数据字典将编码转化为显示值返回，type-数据字典大类编码，name-对象属性名
    function codeToValue(rows,type,name){
        var list  = DictionaryCache.get(type);
        if(list!=undefined&&list.length>0){
            for(var  i = 0 ; i < rows.length ; i++){
                var obj = rows[i];
                var temp = obj[name];
                for(var j = 0 ; j < list.length ; j++){
                    if(temp == list[j].dataCode){
                        obj[name] = list[j].dataValue;
                        rows[i] = obj;
                        break;
                    }
                }
            }
        }
        return rows;
    }
    function
    toHtml(target, rows,filename) {
        rows = rows || getRows(target);
        if(target.id == 'villagejbxx_table'){//村庄基础信息数据字典处理
            rows = codeToValue(rows,"villageType","villageType");
        } else if(target.id == 'newhousingtables'){//新建房屋基础信息数据字典处理
            rows = codeToValue(rows,"HouseType","htype");
            rows = codeToValue(rows,"ImpType","progress");
            rows = codeToValue(rows,"housingStructure","housingStructure2");
        } else if(target.id == 'farmhouse_table'){//农房基础信息数据字典处理
            rows = codeToValue(rows,"isBetter","isbetter");
            rows = codeToValue(rows,"PersonType","persontype");
            rows = codeToValue(rows,"housingStructure","housingstructure");
            rows = codeToValue(rows,"BetterType","bettertype");
        }else if(target.id =='statisticstables'){//农房改善计划
            rows = codeToValue(rows,"BetterType","betterType");
            rows = codeToValue(rows,"PersonType","personType");
            rows = codeToValue(rows,"sjcjStatusType","status");
        }else if(target.id =='farmHouseStatisticsTables'||target.id =='farmHouseStatisticsTables2'){//计划或实际农房改善详细
            rows = codeToValue(rows,"BetterType","bettertype");
            rows = codeToValue(rows,"PersonType","persontype");
        }else if(target.id =='table_farmhousejbxxHouseVillages'){//随机抽取
            rows = codeToValue(rows,"RandomType","rtype");
            rows = codeToValue(rows,"BetterType","bettertype");
            rows = codeToValue(rows,"PersonType","persontype");
        }else if(target.id =='new_farmhouse_table'){//安置户数
            rows = codeToValue(rows,"isBetter","isBetter");
            rows = codeToValue(rows,"BetterType","bettertype");
            rows = codeToValue(rows,"PersonType","persontype");
            rows = codeToValue(rows,"housingStructure","housingstructure");
        }else if(target.id =='fundsummary_table'){
            rows = codeToValue(rows,"FUNDSUMSTATUS","status");
        }else if(target.id =='hmtableList'){
            rows = codeToValue(rows,"FUNDSUMSTATUS","status");
        }
        var dg = $(target);
        var data = ['<div class=""><table border="1" rull="all" style="border-collapse:collapse"></div>'];
        var fields = dg.datagrid('getColumnFields', true).concat(dg.datagrid('getColumnFields', false));
        var trStyle = 'height:auto;padding:5px';
        var trStyle1 = 'height:100px!important';
        var style1='text-align:left:border:1px solid red;height:100px!important';
        var tdStyle0 = 'vertical-align:middle;padding:5px 0;height:auto;text-align:center';
        var tdStyle1 = 'padding:5px 0;height:100px;text-align:left';
        //插入表头数据
        /*var titleHtml=`<table >
                 <tr class="trStyle" style="text-align: center;height:50px;line-height: 50px" >
                  <td colspan="">${filename}</td>
                  </tr>
                 </table>`;
        data.unshift(titleHtml);*/

        //if(target.id =='statisticstables'||target.id=='jhgsworklist'||target.id=='sjgsworklist'){
            if(filename != null ){
                var tempName = filename.replace(".xls","");
                data.push('<tr style="' + trStyle + '">')
                data.push('<th style="\' + tdStyle0 + \';height: auto;"colspan="'+fields.length+'"><font size="20px;">'+tempName+'</font></th>')
                data.push('</tr>');
            }

        //}

        if(target.id =='tableList' || target.id =='tableList_zkl'){//表头特殊处理
            data.push('<tr style="' + trStyle + '">');
            data.push('<th rowspan="2" style="' + tdStyle0 + '">设区市</th>');
            data.push('<th rowspan="2" style="' + tdStyle0 + '">县（市、区）</th>');
            data.push('<th rowspan="2" style="' + tdStyle0 + '">省定各市目标任务<br/>及各市分解至<br/>县市区数量（户）</th>');
            data.push('<th colspan="9" style="' + tdStyle0 + '">省定目标任务完成情况</th>');
            data.push('<th colspan="5" style="' + tdStyle0 + '">各地计划新建项目</th>');
            data.push('</tr>');
            /*data.push('<tr style="' + trStyle + '">');
            data.push('<th style="' + tdStyle0 + '">实际完成<br/>总数（户）</th>');
            data.push('<th style="' + tdStyle0 + '">其中：对<br/>应省定任务<br/>完成数<br/>（户）</th>');
            data.push('<th style="' + tdStyle0 + '">其中：推<br/>动农户自行<br/>改善数<br/>（户）</th>');
            data.push('<th style="' + tdStyle0 + '">完成总数与<br/>目标任务数<br/>的占比（%）</th>');
            data.push('<th style="' + tdStyle0 + '">进城购房<br/>改善（户）</th>');
            data.push('<th style="' + tdStyle0 + '">入镇购房<br/>改善（户）</th>');
            data.push('<th style="' + tdStyle0 + '">新型农村<br/>社区改善（户）</th>');
            data.push('<th style="' + tdStyle0 + '">城镇集中<br/>安置区<br/>改善（户）</th>');
            data.push('<th style="' + tdStyle0 + '">规划发展<br/>村庄就地<br/>新建翻建<br/>改善（户）</th>');
            data.push('<th style="' + tdStyle0 + '">项目总数<br/>（个）</th>');
            data.push('<th style="' + tdStyle0 + '">其中：城镇改<br/>善项目（个）</th>');
            data.push('<th style="' + tdStyle0 + '">其中：乡村改<br/>善项目（个）</th>');
            data.push('<th style="' + tdStyle0 + '">已开工<br/>项目（个）</th>');
            data.push('<th style="' + tdStyle0 + '">已竣工<br/>项目（个）</th>');
            data.push('</tr>');*/
            data.push('<tr style="' + trStyle + '">');
                    for (var i = 0; i < fields.length; i++) {
                var col = dg.datagrid('getColumnOption', fields[i]);
                var tdStyle = tdStyle0 + ';width:' + col.boxWidth + 'px;height: 32px;';
                if(fields[i] != "city" && fields[i] != "sjbm" && fields[i] != "target"){
                    data.push('<th style="' + tdStyle + '">' + col.title + '</th>');
                }
            }
            data.push('</tr>');
        }  else if(target.id =='fundsummary_table'){
            data.push('<tr style="' + trStyle + '">');
            data.push('<th rowspan="2" style="' + tdStyle0 + '">状态</th>');
            data.push('<th rowspan="2" style="' + tdStyle0 + '">县（市、区）</th>');
            data.push('<th colspan="6" style="' + tdStyle0 + '">结算年度内完成改善人口（人）</th>');
            data.push('<th colspan="4" style="' + tdStyle0 + '">农房建筑面积（万㎡）</th>');
            data.push('<th colspan="4" style="' + tdStyle0 + '">公共服务设施建筑面积（万㎡）</th>');
            data.push('<th colspan="4" style="' + tdStyle0 + '">基础设施实际投入额（万元）</th>');
            data.push('<th colspan="4" style="' + tdStyle0 + '">公共服务设施实际投入额（万元）</th>');
            data.push('</tr>');
            data.push('<tr style="' + trStyle + '">');
            for (var i = 0; i < fields.length; i++) {
                var col = dg.datagrid('getColumnOption', fields[i]);
                var tdStyle = tdStyle0 + ';width:' + col.boxWidth + 'px;height: 32px;';
                if(fields[i] != "status" && fields[i] != "unitName" ){
                    data.push('<th style="' + tdStyle + '">' + col.title + '</th>');
                }
            }
            data.push('</tr>');
        } else {
            data.push('<tr style="' + trStyle + '">');
            for (var i = 0; i < fields.length; i++) {
                var col = dg.datagrid('getColumnOption', fields[i]);
                var tdStyle = tdStyle0 + ';width:' + col.boxWidth + 'px;height: 32px;';
                if(col.title != "附件上传"){
                    data.push('<th style="' + tdStyle + '">' + col.title + '</th>');
                }
            }
            data.push('</tr>');
        }

        if(target.id =='workcheck_view_table' || target.id =='projectcheck_view_table' || target.id =='tableList' || target.id =='tableList_zkl'){//合并单元格
                for(var k = 0 ; k < rows.length ; k++ ){
                    data.push('<tr style="' + trStyle + '">');
                    var row = rows[k];
                    for (var i = 0; i < fields.length; i++) {
                        var field = fields[i];
                        if( field != "fj" ){//附件不下载
                            if(field != "content1" && field != "content2" && field != "city"  ){//规定合并单元格字段
                                data.push(
                                    '<td  style="' + tdStyle0 + ';mso-number-format:\'\\@\';">' + (row[field] == null ? "" : row[field]) + '</td>'
                                );
                            } else {
                                //向上一条记录比较，一致时不增加这条记录
                                var isload = true;
                                if(k != 0){
                                    var rowtemp = rows[k-1];
                                    if(row[field] == rowtemp[field]){
                                        isload = false;
                                    }
                                }
                                if(isload){
                                    //循环下面的数据，确定合并几行数据
                                    var temp = 1;
                                    if( k != (rows.length - 1) ){
                                        for(var j = k+1 ; j <  rows.length ; j++){
                                            var rowtemp = rows[j];
                                            if(row[field] == rowtemp[field]){
                                                ++temp;
                                            }
                                        }
                                    }
                                    data.push(
                                        '<td rowspan="' + temp + '" style="' + tdStyle0 + ';mso-number-format:\'\\@\';">' + (row[field] == null ? "" : row[field]) + '</td>'
                                    );
                                }
                            }

                        }
                    }
                    data.push('</tr>');
                }
                if(target.id =='workcheck_view_table' || target.id =='projectcheck_view_table'){
                    //增加签字和日期
                    data.push('<tr style="' + trStyle + ' ' + trStyle1 +'">');
                    data.push(
                        '<td colspan="' + (fields.length-1) + '" style="' + tdStyle1 + ';mso-number-format:\'\\@\';">签字：</td>'
                    );
                    data.push('</tr>');
                    data.push('<tr style="' + trStyle + '">');
                    data.push(
                        '<td colspan="' + (fields.length-1) + '" style="' + tdStyle1 + ';mso-number-format:\'\\@\';">日期：</td>'
                    );
                }
                data.push('</tr>');
        } else {
            $.map(rows, function (row) {
                data.push('<tr style="' + trStyle + '">');
                for (var i = 0; i < fields.length; i++) {
                    var field = fields[i];
                    data.push(
                        '<td style="' + tdStyle0 + ';mso-number-format:\'\\@\';">' + (row[field] == null ? "" : row[field]) + '</td>'
                    );
                }
                data.push('</tr>');
            });
        }
        data.push('</table>');
        return data.join('');
    }

    function toArray(target, rows) {
        rows = rows || getRows(target);
        var dg = $(target);
        var fields = dg.datagrid('getColumnFields', true).concat(dg.datagrid('getColumnFields', false));
        var data = [];
        var r = [];
        for (var i = 0; i < fields.length; i++) {
            var col = dg.datagrid('getColumnOption', fields[i]);
            r.push(col.title);
        }
        data.push(r);
        $.map(rows, function (row) {
            var r = [];
            for (var i = 0; i < fields.length; i++) {
                r.push(row[fields[i]]);
            }
            data.push(r);
        });
        return data;
    }

    function print(target, param) {
        var title = null;
        var rows = null;
        if (typeof param == 'string') {
            title = param;
        } else {
            title = param['title'];
            rows = param['rows'];
        }
        var newWindow = window.open('', '', 'width=800, height=500');
        var document = newWindow.document.open();
        var content =
            '<!doctype html>' +
            '<html>' +
            '<head>' +
            '<meta charset="utf-8">' +
            '<title>' + title + '</title>' +
            '</head>' +
            '<body>' + toHtml(target, rows) + '</body>' +
            '</html>';
        document.write(content);
        document.close();
        newWindow.print();
    }

    function b64toBlob(data) {
        var sliceSize = 512;
        var chars = atob(data);
        var byteArrays = [];
        for (var offset = 0; offset < chars.length; offset += sliceSize) {
            var slice = chars.slice(offset, offset + sliceSize);
            var byteNumbers = new Array(slice.length);
            for (var i = 0; i < slice.length; i++) {
                byteNumbers[i] = slice.charCodeAt(i);
            }
            var byteArray = new Uint8Array(byteNumbers);
            byteArrays.push(byteArray);
        }
        return new Blob(byteArrays, {
            type: ''
        });
    }

    function toExcel(target, param) {
        var filename = null;
        var rows = null;
        var worksheet = 'Worksheet';
        if (typeof param == 'string') {
            filename = param;
        } else {
            filename = param['filename'];
            rows = param['rows'];
            worksheet = param['worksheet'] || 'Worksheet';
        }
        var dg = $(target);
        var uri = 'data:application/vnd.ms-excel;base64,'
            ,
            template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{table}</body></html>'
            , base64 = function (s) {
                return window.btoa(unescape(encodeURIComponent(s)))
            }
            , format = function (s, c) {
                return s.replace(/{(\w+)}/g, function (m, p) {
                    return c[p];
                })
            };


        var table = toHtml(target, rows,filename);
        var ctx = {worksheet: worksheet, table: table};
        var data = base64(format(template, ctx));
        if (window.navigator.msSaveBlob) {
            var blob = b64toBlob(data);
            window.navigator.msSaveBlob(blob, filename);
        } else {
            var alink = $('<a style="display:none"></a>').appendTo('body');
            alink[0].href = uri + data;
            alink[0].download = filename;
            alink[0].click();
            alink.remove();
        }
    }


    $.extend($.fn.datagrid.methods, {
        toHtml: function (jq, rows) {
            return toHtml(jq[0], rows);
        },
        toArray: function (jq, rows) {
            return toArray(jq[0], rows);
        },
        toExcel: function (jq, param) {
            return jq.each(function () {
                toExcel(this, param);
            });
        },
        print: function (jq, param) {
            return jq.each(function () {
                print(this, param);
            });
        }
    });
});
