define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');


    var TaskAdd = require('./task.add');
    var TaskEdit = require('./task.edit');
    var RwListExp = require('./rwList.exp');
    var Events = require('core/events');
   /* var TaskView = require('./task.view');
    var TaskRemove = require('./task.remove');*/

    // 业务信息
    var Task = Page.extend(function() {

    	this.injecte([
          new TaskAdd('task_add'),
          new TaskEdit('task_edit'),
          new RwListExp('rwList_exp'),
         /* new TaskView('task_view'),
          new TaskRemove('task_remove')*/
    	]);

    	// @override
    	this.load = function(panel) {
            var table = this.table = panel.find('table');
            this.$autoHeight('north', $('#task-info-main', panel));

        //下一页
        panel.find("#task_next").on("click",function(){
            var url = Config.ContextPath + 'modules/sjcj/statisticsList/statisticsList.jsp?stype=1'
            Events.trigger('open.MenuTab', {
            id: 'aa',
            text: '改善计划编制',
            url: url,
            closable: true
          });
        });
        //上一页
        panel.find("#task_prev").on("click",function(){
          Events.trigger('close.MenuTab', 'aa');
        });

            var url = "service/task/taskassignment";

            table.cdatagrid({
                controller: this,
                url: url
            });
            panel.find('#tyear').combobox({
                onLoadSuccess: function (data) {
                    var data = $('#tyear').combobox('getData');//获取所有下拉框数据
                    if (data.length > 0) {
                        $('#tyear').combobox('select',data[0].year);
                    }
                }
            });
            //第一次加载
            panel.find('#rwfirst').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoFirst",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    /*if (da["yhjb"] == "fsj") {*/
                    $('#rwfirst').combobox('select', da["unitCode"]);
                    $("#rwfirst").combobox('readonly', true);
                    /*  }*/
                }
            });
            panel.find('#rwsecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#rwsecond').combobox('select', da["unitCode"]);
                            $("#rwsecond").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#rwthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#rwthird').combobox('select', da["unitCode"]);
                            $("#rwthird").combobox('readonly', true);
                        }
                    }

                }
            });
        panel.find('#rwfourth').combobox({
          url: Config.ContextPath + "service/jhgswork/getUnitInfofourth",
          valueField: 'unitCode',
          textField: 'unitName',
          onLoadSuccess: function (data) {
            var da = data[0];
            if (da != undefined) {
              if (da["yhjb"] == "fsj") {
                $('#rwfourth').combobox('select', da["unitCode"]);
                $("#rwfourth").combobox('readonly', true);
              }
            }

          }
        });
            panel.find('#rwfirst').combobox({
                onChange: function() {
                    var code = panel.find('#rwfirst').combobox('getValue');
                    panel.find('#rwsecond').combobox('clear');
                    // 重新获取数据
                    panel.find('#rwsecond').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfoSecond?code=' + code);
                }
            });
            panel.find('#rwsecond').combobox({
                onChange: function() {
                    var code = panel.find('#rwsecond').combobox('getValue');
                    panel.find('#rwthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#rwthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });

        /*//查询
        panel.find('#taskCx').click(function() {
          var fyear = $("#tyear").val();
          var first = $("#rwfirst").val();
          var second = $("#rwsecond").val();
          var third = $("#rwthird").val();
          var params = "";
          params =  "&s_tyear=" + encodeURI(encodeURI(fyear))+"&s_first="+encodeURI(encodeURI(first))+"&s_second="+second+"&s_third="+third;
          if(params != ""){
            params = params.substring(1,params.length);
          }
          table.cdatagrid({
            controller: this,
            url : Config.ContextPath + "service/task/taskassignment?" + params ,
          });
        });*/

           //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isZj = false;
                var iszhen = false;
                var isck = false;//仅有查看功能
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'){
                        isZj = true;
                        break;
                    }
                    if(rlt[i].roleCode == '0013'){
                        iszhen = true;
                    }
                    if(rlt[i].roleCode == '0015'){
                        isck = true;
                    }
                }
                if(!isZj){//只有省级能新增
                    $("#task_add_btn").parent("td").next().remove();
                    $('#task_add_btn, #task_add_btn + hr', panel).remove();
                    /*if(iszhen){//镇级不能下发任务
                      $("#task_edit_btn").parent("td").next().remove();
                      $('#task_edit_btn, #task_add_btn + hr', panel).remove();
                    }*/
                }
                if(!iszhen){//非镇级去掉上一步下一步
                    panel.find(".cy-btn-position").hide();
                }
                if(isck){
                    $("#task_edit_btn").parent("td").next().remove();
                    $('#task_edit_btn, #task_edit_btn + hr', panel).remove();
                    $("#rwList_exp_btn").parent("td").next().remove();
                    $('#rwList_exp_btn, #rwList_exp_btn + hr', panel).remove();

                }

            });

        };

    });

    return Task;
});
