define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var TaskAdd = require('./task.add');

	var TaskEdit = TaskAdd.extend(function() {
		var _self = this;
		
		// @override
		this.load = function(panel, data) {

            var table = panel.find("#taskfp_table");
            table.cdatagrid({
                controller: this,
                url: Config.ContextPath +'service/task/taskassignment/getCurrentTasks/'+data.unitCode+'/'+data.tyear,
                onLoadSuccess:rwfploader
            });
             function rwfploader (){
                 Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                     method: 'get'
                 }).then(function(rlt) {
                     var isZj = false;
                     for(var i = 0 ; i < rlt.length ; i++){
                         if(rlt[i].roleCode == '0010'){
                             isZj = true;
                             break;
                         }
                     }
                     if(!isZj){
                         $('#taskfp_table').datagrid('beginEdit', 0);
                         var ed = $("#taskfp_table").datagrid('getEditor', {  index : 0,  field : 'detailnum'});
                         $(ed.target).textbox('readonly');
                         $(ed.target).textbox('text-align','center');
                         $("#_easyui_textbox_input61").css(text-align,'center')
                     }
                 });

            }

		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {


            var table = panel.find('#taskfp_table');
            if (!table.cdatagrid('endEdit')) {
                return;
            }
            var data = table.datagrid('getData').rows;
            var json =JSON.stringify(data);
            Core.ajax(Config.ContextPath+'service/task/taskassignment/saveSubTasks', {
                type: 'json',
                method: 'put',
                traditional: true,
                data:{"list":json},
            }).then(function (rlt) {
                if (rlt.isOk) {
                    $.messager.alert('提醒', '分配任务成功！');
                } else {
                    $.messager.alert('提醒', '任务成功失败，原因：' + rlt.msg, 'warning');
                    return false;
                }
            });

		};
		
		// @override
		this.onClose = function(table) {
            table.ctreegrid('reload');
            _self.parent.table.ctreegrid('reload');
		};
	});

	return TaskEdit;
});