define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
	
	var TaskAdd = Page.extend(function() {

		// @override
		this.load = function(panel, data) {
			var form = panel.find('form');
            $('#districtcode1').textbox('setValue', '江苏省');
            $('#districtcode').val('320000000000');
            panel.find("#districtcode1").textbox('textbox').attr('readonly',"readonly");
			form.form('disableValidation')
			.form('focus');
		};
		
		// @override
		this.submit = function(panel, data, closeCallback) {
			var form = panel.find('form');
			
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			
			if (isValid) {
				form.form('ajax', {
					url: Config.ContextPath + 'service/task/taskassignment',
					method: 'post'
				}).then(function(data) {
                    if(data.isOk==false){
                        $.messager.alert('提示',data.msg);
                    }else{
                        closeCallback();
					}
                });
			}
			
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
            table.cdatagrid('reload');
		};
	});
	
	return TaskAdd;
});