define(function (require) {
  var Config = require('config');
  var Page = require('core/page');
  var Core = require('core/core');

  var UserInfoAdd = require('../ctrl/userinfo.add');
  var UserInfoEdit = require('../ctrl/userinfo.edit');
  var UserInfoDelete = require('../ctrl/userinfo.delete');

  var DeptUserInfoPowerView = require('../ctrl/userinfo.power.view');
  var UserInfoAside = require('../ctrl/userinfo.aside');
  UserInfoAside = new UserInfoAside('UserInfoAside');

  var UserInfoUnit = require('../ctrl/userinfo.unit');
  var UserInfoRole = require('../ctrl/userinfo.role');

  var UserInfoResetPassword = require('../ctrl/userinfo.resetpassword');

  return Page.extend(function () {

    this.injecte([
      new UserInfoAdd('userinfo_add'),
      new UserInfoEdit('userinfo_edit'),
      new UserInfoDelete('userinfo_delete'),
      UserInfoAside,
      new UserInfoUnit('userinfo_unit'),
      new UserInfoRole('userinfo_role'),
      new UserInfoResetPassword('userinfo_resetpassword'),
      new DeptUserInfoPowerView('userinfo_power_view')
    ]);

    this.beforeSearch = function () {
      this.currentUserCode = null;
    };

    // @override
    this.load = function (panel) {
      var queryUserUrl = 'service/userinfo2?_search=false&field=userCode&field=loginName&field=userOrder&field=userName&field=isValid&field=primaryUnit';
      var vm = this;

      this.$autoHeight('north', $('#user-info-main', panel));

      //this.AsidePanel = $('#userinfo_panel', panel).layout('panel', 'east');
      this.AsideController = UserInfoAside;



        var table = panel.find('#userInfoTable');
        table.cdatagrid({
            controller: this,
        });
       //行政区划初始化
        panel.find('#user_second').combobox({
            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
            valueField: 'unitCode',
            textField: 'unitName',
            onLoadSuccess: function (list) {
                if(list != null && list.length == 1){
                    $('#user_second').combobox('select', list[0]["unitCode"]);
                    panel.find('#user_third').combobox({
                        url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                        valueField: 'unitCode',
                        textField: 'unitName',
                        onLoadSuccess: function (list2) {
                            if(list2 != null && list2.length == 1){
                                $('#user_third').combobox('select', list2[0]["unitCode"]);
                                panel.find('#user_fourth').combobox({
                                    url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+list2[0]["unitCode"] ,
                                    valueField: 'unitCode',
                                    textField: 'unitName',
                                    onLoadSuccess: function (list3) {
                                        if(list3 != null && list3.length == 1){
                                            $('#user_fourth').combobox('select', list3[0]["unitCode"]);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });

        //行政区划联动
        panel.find('#user_second').combobox({
            onChange: function(newValue,oldValue) {
                panel.find('#user_third').combobox('clear');
                panel.find('#user_fourth').combobox('clear');
                // 重新获取数据
                if(newValue != null){
                    panel.find('#user_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                }
            }
        });
        //行政区划联动
        panel.find('#user_third').combobox({
            onChange: function(newValue,oldValue) {
                panel.find('#user_fourth').combobox('clear');
                // 重新获取数据
                if(newValue != null){
                    panel.find('#user_fourth').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+newValue);
                }
            }
        });


      Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
            method: 'get'
        }).then(function (rlt) {
            var isSt = false;
            if(rlt != null && rlt.length > 0){
              for(var i = 0 ; i < rlt.length ; i++){
                var obj = rlt[i];
                if(obj.roleCode == '0010'){
                    isSt = true;
                    break;
                }
              }
            }
            /*if(isSt){
                queryUserUrl = 'system/userinfo?_search=false&field=userCode&field=loginName&field=userOrder&field=userName&field=isValid&field=primaryUnit';
            }*/
              table.cdatagrid({
              controller: this,
              url: queryUserUrl,
              queryParams: {
                     s_isValid: 'T'
                 },
                 rowStyler: function (index, row) {
                     if (row.isValid === 'F') {
                         return {'class': 'ban'};
                     }
                 },
                 onSelect: function (index, row) {
                     if (vm.currentUserCode !== row.userCode) {
                         vm.currentUserCode = row.userCode;
                         vm.selectUser(row);
                     }
                 },
                 onLoadSuccess: function () {
                     var table = $(this);
                     var rows = table.datagrid('getRows');

                     if (rows.length) {
                         // 重新刷新后，获取之前选中对象在新数据中的index
                         var index = 0;
                         for (var i = 0; i < rows.length; i++) {
                             if (rows[i].userCode === vm.currentUserCode) {
                                 index = i;
                                 break;
                             }
                         }

                         // 重置，确保数据能够被刷新
                         vm.currentUserCode = null;
                         table.datagrid('selectRow', index);
                     } else {
                         vm.clearPanel();
                     }
                 }
             });
        });


    };

    this.selectUser = function (user) {
      var vm = this;

      if (!user || !user.userCode) {
        return this.clearPanel();
      }

      /*this.AsidePanel.data('panel').options.onLoad = function () {
        vm.AsideController.init($(this), user);
      };*/
      //this.AsidePanel.panel('refresh', Config.ViewContextPath + 'modules/sys/userinfo/userinfo-aside.html');
    };

    this.clearPanel = function () {
      this.currentUserCode = null;
      //this.AsidePanel.data('panel').options.onLoad = $.noop;
      //this.AsidePanel.panel('refresh', Config.ViewContextPath + 'modules/sys/commons/no-data.html');
    };
  });
});
