define(function (require) {
  var Config = require('config');
  var Core = require('core/core');
  var Page = require('core/page');

  // 删除数据字典
  var UserInfoDelete = Page.extend(function () {
    var vm = this;

    // @override
    this.submit = function (table, data) {
      var userCodes = [];
      for (var i = 0; i < data.length; i++) {
        userCodes.push(data[i].userCode);
      }
      //增加不能删除当前用户的操作
        Core.ajax(Config.ContextPath + 'service/common/getLoginUser' , {
            method: 'get'
        }).then(function (rlt) {
            if(userCodes == rlt.userInfo.userCode){
                $.messager.alert('提醒', '不能删除当前登录用户！' ,'warning');
                return;
            } else {
                Core.ajax(Config.ContextPath + 'system/userinfo/' + userCodes, {
                    type: 'json',
                    method: 'post',
                    data: {
                        _method: 'delete'
                    }
                }).then(function () {
                    return require('loaders/cache/loader.system').loadAll()
                }).then(function () {
                    vm.parent.clearPanel();
                    table.datagrid('reload');
                });
            }
        });
    };
  });

  return UserInfoDelete;
});
