define(function (require) {
  var Config = require('config');
  var Core = require('core/core');
  var Page = require('core/page');

  // 编辑角色信息
  var UserInfoAdd = Page.extend(function () {
    var vm = this;

    // @override
    this.object = {
      isValid: 'T'
    };

    // @override
    this.load = function (panel) {
      var form = panel.find('form');

      this.data = $.extend({}, this.object);

        /*$('#userinfo_info_primaryUnit').combotree({
            onChange: function(newValue,oldValue){
                Core.ajax(Config.ContextPath + 'system/unitinfo/' + newValue, {
                    method: 'get'
                }).then(function (rlt) {
                    $('#userinfo_info_userTag').combotree('setValue', rlt.unitTag);
                });
            }
        });*/
        Core.ajax(Config.ContextPath + 'service/common/getLoginUser' , {
            method: 'get'
        }).then(function (rlt) {
            var data = new Object();
            data.creator  = rlt.userInfo.userCode;
            data.updator = rlt.userInfo.userCode;
            form.form('disableValidation').form('load', data)
                .form('focus');
        });
    };

    // @override
    this.submit = function (panel, data, closeCallback) {
      var form = panel.find('form');
      
      var obj = form.form('value');
      if(obj.loginName == null || obj.loginName == ''){//为空时自动赋值
        if(obj.primaryUnit != null && obj.primaryUnit != ''){
            var arr = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z'];
            var ln = obj.primaryUnit.substring(0,9)+arr[randomRange(0,25)]+randomRange(0,9)+randomRange(0,9)
            panel.find('#userinfo_loginName').textbox('setValue',ln);
        }
      }

      // 开启校验
      var isValid = form.form('enableValidation').form('validate');
      var obj = form.form('value');


        if (isValid) {
            var primaryUnit = obj.primaryUnit;
            var roleCode = obj.roleCode;
            //增加属地级别和角色一致的校验
            Core.ajax(Config.ContextPath + 'system/unitinfo/' + primaryUnit, {
                type: 'json',
                method: 'get'
            }).then(function (unitinfo) {
                if((unitinfo.unitType == 1 && obj.roleCode == "0010") ||
                    (unitinfo.unitType == 2 && obj.roleCode == "0011") ||
                    (unitinfo.unitType == 3 && obj.roleCode == "0012") ||
                    (unitinfo.unitType == 4 && obj.roleCode == "0013")){
                    form.form('ajax', {
                        url: Config.ContextPath + 'system/userinfo',
                        method: 'post',
                        data: data
                    }).then(function (rlt) {
                        //给用户添加角色
                        $("#userinfo_info_userCode").val(rlt.userCode);
                        obj.obtainDate = new Date();
                        obj.changeDesc = "普通用户" + rlt.userName + "新增用户添加角色";
                        form.form('ajax', {
                            url: Config.ContextPath + 'service/userinfo2/saveUserRole',
                            method: 'post',
                            data: obj,
                        }).then(function () {
                            return require('loaders/cache/loader.system').loadAll()
                        });
                    }).then(function () {
                        vm.parent.clearPanel();
                        closeCallback(true)
                    });
                } else {
                    $.messager.alert('提醒', '属地级别需与用户角色一致！如属地为镇级，用户角色必须设置为镇级用户', 'warning');
                }


            })
        }
      return false;
    };

      function randomRange(min, max) { // min最小值，max最大值
          return Math.floor(Math.random() * (max - min)) + min;
      }
    // @override
    this.onClose = function (table, submited) {
      if (submited) {
        table.datagrid('reload');
      }
    };
  });

  return UserInfoAdd;
});
