<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="unit-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; height: auto; margin-bottom: 0;">
            <form class="clearFromValue">
                <div class="search-item">
                    <label id="d@organizationName">名称</label>
                    <input class="easyui-textbox" name="unitName" id="s_unitName"/>
                </div>
                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
                <a style="color:rgb(255,114,114); ">说明：省级用户可维护全部行政区划，其他用户可以维护村级行政区划。行政区划级别：1-省级，2-市级，3-县区级，4-镇级，5-村级</a>
            </form>
        </div>
    </div>

    <div region="center" border="false" style="padding: 4px;">
            <table
                    fitColumns="true"
                    fit="true"
                    id="tg"
                    search=".search"
                    sortName="unitOrder"
                    sortOrder="asc"
                    remoteSort="false"
                    data-options="method: 'get',idField: 'unitCode',treeField: 'unitName', showFooter: true,toolbar:'.temp-toolbar'">
                <thead frozen="true">
                <tr>

                    <th id="f@name" data-options="field:'unitName',editor:'text'">名称</th>
                </tr>
                </thead>
                <thead>
                <tr>
                    <th id="f@number" data-options="field:'unitCode',editor:'text'" width="120" align="center">部门编码</th>
                    <th data-options="field:'unitShortName'" width="100" align="center">简称</th>
                    <th data-options="field:'unitType'" width="80" align="center"  format="Dictionary:UnitType">级别</th>
                    <th data-options="field:'unitOrder',editor:'text'" width="40" align="center" sortable="true">排序</th>
                    <th data-options="field:'isValid'" format="Dictionary:YesOrNo" align="center">是否在用(T-使用,F-禁用)</th>
                    <th id="f@describe" data-options="field:'unitDesc',editor:'text'" width="330">描述</th>
                </tr>
                </thead>
            </table>

            <div class="temp-toolbar">
                <a iconCls="icon-add" href="modules/sys/unitinfo/unitinfo-info.html" trigger="single" target="dialog"
                   rel="unitinfo_add"
                   title="新增 {{unitName}} 下级" width="800" height="550" btnValue="添加"><p id="f@link.subOrganization">
                    新增下级</p>
                </a>
                <hr>
                <a iconCls="icon-edit" href="modules/sys/unitinfo/unitinfo-edit.html" trigger="single"
                   target="dialog" rel="unitinfo_edit" title="编辑 {{unitName}}" width="800" height="550"  btnValue="保存"<%--buttons="[{method:'submit',text:'保存'}]" --%>>
                    <p id="f@link.edit">编辑</p></a>
                <hr>
                <hr>
                <a iconCls="icon-base icon-base-ban" trigger="single" target="confirm" rel="unitinfo_remove"
                   title="是否确定删除 {{unitName}}？">
                    <p id="f@btn.delete">删除</p></a>
            </div>
    </div>
</div>

<script type="text/javascript">
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs(['modules/sys/unitinfo/ctrl/unitinfo','core/filter/filter.dictionary'],
            function (UnitInfo,FilterDictionary) {
                FilterDictionary.add([
                    'YesOrNo',
                    'UnitType']
                ).then(function () {
                    window.UnitInfo = new UnitInfo('UnitInfo', panel);
                    window.UnitInfo.load(panel);
                });
            });
    };
</script>