define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var UnitInfoAdd = require('../ctrl/unitinfo.add');

    var UnitInfoEdit = UnitInfoAdd.extend(function () {
        var isSt = false;
        Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
            method: 'get'
        }).then(function (rlt) {
            if (rlt != null && rlt.length > 0) {
                for (var i = 0; i < rlt.length; i++) {
                    var obj = rlt[i];
                    if (obj.roleCode == '0010') {
                        isSt = true;
                        break;
                    }
                }
            }
        });
        var _self = this;
        this.renderButton = function (btn, data) {
            var flag = false;
            if (isSt || (data.unitType == '5')) {//省厅可以编辑任何单位，普通用户只能编辑村级单位
                flag = true;
            }
            return flag;
        };
        // @override
        this.load = function (panel, data) {
            _self = this;
            var form = panel.find('form');
            Core.ajax(Config.ContextPath + 'system/unitinfo/' + data.unitCode, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                data.parentUnit2 = data.parentUnit;
                _self.data = data;
                form.form('disableValidation')
                    .form('load', data)
                    .form('focus');

                if(isSt){//省厅可变更上级部门
                    panel.find("#parentChange").show();
                }
            });
            if (data.unitManager != null && data.unitManager != '') {
                panel.find("#unitinfo-edit_unlocated").hide();
                panel.find("#unitinfo-edit_located").show();
            }
            $('#unitinfo-edit-location').click(function () {
                var lng = 0;
                var lat = 0;
                var man = $('#unitinfo-edit-unitManager').val();
                if (man != null && man.length > 0) {
                    var mans = man.split(",");
                    if (mans.length == 2) {
                        lng = mans[0];
                        lat = mans[1];
                    }
                }
                $('#unitinfo-edit-map-iframe').attr("src", "../../modules/sjcj/map/locationmap.jsp?dialogname=unitinfo-edit-map-dialog&module=unitinfo-edit&id=unitinfo-edit-unitManager&lng=" + lng + "&lat=" + lat);

                $('#unitinfo-edit-map-dialog').dialog({
                    title: "选择中心点",
                    width: 750,
                    height: 500
                });
            });
        };

        // @override
        this.submit = function (panel, data, closeCallback) {
            var form = panel.find('form');
            form.form('enableValidation');
            var isValid = form.form('validate');
            //普通用户只能保存级别为镇级的单位
            var obj = form.form('value');
            if (!isSt && obj.unitType != '5') {
                $.messager.alert('提醒', '普通用户编辑级别只能为“村级”，请修改信息后保存！', 'warning');
                isValid = false;
            }
            var jwd = _self.panel.find("#unitinfo-edit-unitManager").val();
            if (jwd == null || jwd.length < 1) {
                $.messager.alert('提醒', '请先定位！', 'warning');
                isValid = false;
            }
            if (isValid) {
                data._method = 'PUT';

                form.form('ajax', {
                    data: data,
                    url: Config.ContextPath + 'service/userinfo2/editUnitInfo/' + data.unitCode,
                    method: 'put'
                }).then(closeCallback);
            }

            return false;
        };
    });

    return UnitInfoEdit;
});
