define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    var UnitInfoAdd = Page.extend(function () {
        var isSt = false;
        Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
            method: 'get'
        }).then(function (rlt) {
            if (rlt != null && rlt.length > 0) {
                for (var i = 0; i < rlt.length; i++) {
                    var obj = rlt[i];
                    if (obj.roleCode == '0010') {
                        isSt = true;
                        break;
                    }
                }
            }
        });
        // @override
        this.object = {
            // 默认管理业务
            // unitType: '1',

            // 默认启用
            isValid: 'T'
        };
        this.renderButton = function (btn, data) {
            var flag = false;
            if (isSt || (data.unitType == '4')) {//省厅可以增加任何下级用户，普通用户只能增加增加村级单位
                flag = true;
            }
            return flag;
        };
        var parentUnitManager;
        var _self;
        var parentUnitCode;
        // @override
        this.load = function (panel, data) {
            var form = panel.find('form');
            parentUnitManager = data.unitManager;
            _self = this;
            parentUnitCode = data.unitCode;
            form
                .form('disableValidation')
                .form('load', $.extend({}, this.object, {
                    parentUnit: data.unitCode,
                    parentUnitName: data.parentUnitName
                }))
                .form('focus');

            if (!data.unitCode) {
                form.form('readonly', 'parentUnit');
            }

            $('#unitinfo-info-location').click(function () {
                var lng = 0;
                var lat = 0;
                var man = $('#unitinfo-info-unitManager').val();
                if (man != null && man.length > 0) {
                    var mans = man.split(",");
                    if (mans.length == 2) {
                        lng = mans[0];
                        lat = mans[1];
                    }
                } else {
                    lng = parentUnitManager.split(",")[0];
                    lat = parentUnitManager.split(",")[1];
                }
                $('#unitinfo-info-map-iframe').attr("src", "../../modules/sjcj/map/locationmap.jsp?dialogname=unitinfo-info-map-dialog&module=unitinfo-info&id=unitinfo-info-unitManager&lng=" + lng + "&lat=" + lat);

                $('#unitinfo-info-map-dialog').dialog({
                    title: "选择中心点",
                    width: 750,
                    height: 500
                });
            });


        };

        // @override
        this.submit = function (panel, data, closeCallback) {
            var form = panel.find('form');

            form.form('enableValidation');
            var isValid = form.form('validate');
            //普通用户只能保存级别为镇级的单位
            var obj = form.form('value');
            var unitCode = obj.unitCode;
            var reg = /^\d{12}$/;
            if(reg.test(unitCode) && reg.test(parentUnitCode)){//编码校验：12位数字，且前缀和父机构编码一致
                var fc = parentUnitCode.split("");
                var uc = unitCode.split("");
                for(var i = 0 ; i < fc.length ; i++){
                    if(fc[i] != 0 && fc[i] != uc[i]){
                        $.messager.alert('提醒', '部门编码（即行政区划代码）前缀必须和上级编码前缀一致！', 'warning');
                        return false;
                    }
                }
            } else {
                $.messager.alert('提醒', '部门编码（即行政区划代码）必须为12位数字！', 'warning');
                return false;
            }
            if (!isSt && obj.unitType != '5') {
                $.messager.alert('提醒', '普通用户新增级别只能为“村级”，请修改信息后保存！', 'warning');
                return false;
            }
            var jwd = _self.panel.find("#unitinfo-info-unitManager").val();
            if (jwd == null || jwd.length < 1) {//定位必选校验
                $.messager.alert('提醒', '请先定位！', 'warning');
                return false;
            }
            if (isValid) {
                form.form('ajax', {
                    url: Config.ContextPath + 'service/userinfo2/createUnitInfo',
                    method: 'post'
                }).then(closeCallback);
            }
            return false;
        };

        // @override
        this.onClose = function (table, data) {
            if (!data) {
                return;
            }

            var talbe = this.parent.table;

            this.parent.currentUnit = data.unitCode;

            var children = table.treegrid('getChildren', data.parentUnit);

            // 子节点
            if ("0" !== data.parentUnit && children.length) {
                //this.parent.table.treegrid('reload', data.parentUnit);
                this.parent.table.treegrid('reload')
            }
            // 顶级节点
            else {
                this.parent.table.treegrid('reload');
            }

            require('loaders/cache/loader.system').loadAll();
        };
    });

    return UnitInfoAdd;
});
