<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="images-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <form class="clearFromValue"  id="images_search_form">
                <div class="search-item">
                    <label>年份</label>
                    <input type="text" class="easyui-combobox" name="s_year"
                           url="service/common/getYearList/10" method="get" data-options="valueField:'year',textField:'year'"/>
                </div>

                <div class="search-item">
                    <label>功能模块</label>
                    <input class="easyui-combobox" name="s_emodule" style="width: 180px"
                           target="dictionary"
                           key="moduleExplain"/>
                </div>
                <div class="search-item">
                    <label>图片名称</label>
                    <input class="easyui-textbox" name="s_ename"/>
                </div>

                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>

            </form>
        </div>
    </div>
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table
               fitColumns="true"
               fit="true"
               idField="iid"
               sortName="updatetime"
               sortOrder="desc"
               search=".search"
               rownumbers="false"
               nowrap="false"
               toolbar=".temp-toolbar"  action="images_view">
            <thead>
            <tr>
                <th data-options="field:'iid'"  hidden>图片id</th>
                <th data-options="field:'emodule', width:'10'"  format="Dictionary:moduleExplain">功能模块</th>
               <%-- <th data-options="field:'eid'">关联实体id</th>
                <th data-options="field:'eorder'">图片序号</th>
                <th data-options="field:'type1'">分类字段1</th>--%>
                <th data-options="field:'fslog', width:'20'">图片描述</th>
                <th data-options="field:'ename', width:'20'">图片名称</th>
                <%--<th data-options="field:'efj'">附件</th>--%>
                <th data-options="field:'eremark', width:'30'">备注</th>
                <th data-options="field:'userName', width:'10'">录入用户</th>
                <th data-options="field:'updatetime', width:'10'"  format="Date:yyyy-MM-dd">更新时间</th>

            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">
       <%--     <a iconCls="icon-add" href="modules/sys/images/images-info.jsp" trigger="none"
               target="dialog" rel="images_add" title="新增图片管理表" width="640" height="480" btnValue="添加">新增</a>
            <hr>

            <a iconCls="icon-edit" href="modules/sys/images/images-info.jsp" trigger="single"
               target="dialog" rel="images_edit" title="编辑 {{text}}" width="640" height="480"  buttons="[{method:'submit',text:'保存'}]" >修改</a>
            <hr>--%>

            <a iconCls="icon-edit" href="modules/sys/images/images-view.jsp" trigger="single"
               target="dialog" rel="images_view" title="查看 {{text}}" width="570" height="570" buttons="[{method:'submit',text:'查看'}]">查看</a>
            <hr>

          <%--  <a iconCls="icon-base icon-base-ban" trigger="single"
               target="confirm" rel="images_remove" title="是否确定删除 {{text}}？">删除</a>--%>
        </div>
    </div>
</div>

<script>
    $.parser.onComplete = function(panel) {
        $.parser.onComplete = $.noop;
        var _sjs = Math.random();
        requirejs([
            'core/filter/filter.dictionary',
            'modules/sys/images/ctrl/images',
            'css!plugins/viewer/viewer.min.css'
        ], function(FilterDictionary,Images) {
            FilterDictionary.add([
                'moduleExplain']).then(function () {
                window.Images = new Images('images'+_sjs, panel);
                window.Images.load(panel);
            })

        });
    };

</script>