define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var $ = require('jquery');
    var viewer = require('plugins/viewer/viewer.min');

    var ImagesView = Page.extend(function() {

        var _self = this;

        // @override
        this.load = function(panel, data) {
            var form = panel.find('form');

            Core.ajax(Config.ContextPath+'service/utils/images/'+data.iid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                $('#viewpic_afterout').empty();
                    $('<img>', {
                        src : "data:image/jpg;base64,"+data.efj,
                    }).css({
                        height : "400px",
                        width : "400px",

                    }).appendTo($('#viewpic_afterout'));

                $('#viewpic_afterout').viewer({
                    zIndex : 9999
                });
                form.form('load', data)
                    .form('disableValidation')
                    .form('focus');

            /*    var eid=data.eid;
                var emodule=data.emodule;
                Core.ajax(Config.ContextPath+'service/utils/images/getAttachmentsBTY/'+emodule+'/' + eid, {
                    type: 'json',
                    method: 'get'
                }).then(function(rlt) {


                });*/

            });
        };
    });

    return ImagesView;
});