<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<div class="easyui-layout" fit="true">
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <div class="easyui-layout" fit="true" id="village-info-main">
            <div region="north" border="false" style="height: 60px; padding: 4px;">
                <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
                    <form class="clearFromValue"  id="village_search_form">
                        <div class="search-item">
                            <label>录入年份</label>
                            <input type="text" class="easyui-combobox" name="s_year"
                                   url="service/common/getYearList/10" method="get" data-options="valueField:'year',textField:'year'"/>
                        </div>
                        <div class="search-item">
                            <label>行政区划</label>
                            <input type="text" class="easyui-combotree"
                                   url="service/common/getXZQHByLoginUser" method="get"
                                   data-options="valueField:'dataCode',textField:'dataValue',parentField:'extraCode'"
                                   name="s_town"/>
                        </div>
                        <div class="search-item">
                            <label>自然村名</label>
                            <input type="text" class="easyui-textbox"
                                   name="s_naturalvillage" id="village_naturalvillage"/>
                        </div>
                        <a class="easyui-linkbutton btn-search" iconCls="icon-search" id="village_search">查询</a>
                        <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
                        <input type="hidden" id="villagejbxx_district">
                        <input type="hidden" id="administrativevillage" name="administrativevillage">
                        <br>
                        <a class="warnSelf">说明：请勿在一条记录中录入多个自然村，一个自然村一条记录！<br>
                            自然村数据可随时修改，自然村下有农房信息的不可删除，自然村下无农房信息的可删除！</a>
                    </form>
                </div>
            </div>
            <div class="cy-btn-position">
                <a class="easyui-linkbutton cy-btn cy-btn-forward" id="villagejbxx_prev">上一步：选择行政村</a>
                <a class="easyui-linkbutton cy-btn cy-btn-next"  id="villagejbxx_next">下一步：农房基础信息录入</a>
            </div>
            <div region="center" border="false" style="padding: 4px;">
        <table fit="true" id="villagejbxx_table"
               fitColumns="true"
               idField="vid"
               search=".search"
               rownumbers="false"
               sortName="updateTime"
               sortOrder="desc"
               toolbar=".temp-toolbar" action="villagejbxx_view">
            <thead>
            <tr>

                <th data-options="field:'districtcode'" align="center"  width="12%">行政区划</th>
                <th data-options="field:'town'"  align="center"  width="9%">乡镇</th>
                <th data-options="field:'villageType'"  format="Dictionary:villageType" align="center" width="8%">村庄类型</th>
                <th data-options="field:'administrativevillage'" align="center" width="8%">行政村</th>
                <th data-options="field:'naturalvillage'"  align="center" width="8%">自然村</th>
                <th data-options="field:'household'"  align="center"  width="9%">自然村户籍户数</th>
                <th data-options="field:'population'"  align="center"  width="9%">自然村户籍人口</th>
                <th data-options="field:'villageremark'"  align="center" width="11%"> 原村庄描述</th>
                <th data-options="field:'villageIndustry'"  align="center" width="11%">村庄产业</th>
                <th data-options="field:'userName'"  width="7%">录入用户</th>
                <th data-options="field:'updatetime'" format="Date:yyyy-MM-dd"  width="9%">更新时间</th>
            </tr>
            </thead>
        </table>
        <div class="temp-toolbar">
            <a iconCls="icon-add" href="modules/sjcj/villagejbxx/villagejbxx-info.jsp" trigger="none"
               target="dialog" rel="villagejbxx_add" title="新增村庄基本信息 " width="950" height="600"
               <%--btnValue="添加"--%>
               buttons="[{method:'submitNext',text:'保存并新增'},
               {method:'submit',text:'保存并退出'}]"
               id="village_add_btn">新增</a>
            <hr>

            <a iconCls="icon-edit" href="modules/sjcj/villagejbxx/villagejbxx-info.jsp" trigger="single"
               target="dialog" rel="villagejbxx_edit" title="修改村庄 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}" width="930" height="600"
               buttons="[{method:'submit',text:'保存'}]"
               id="village_edit_btn">修改</a>
            <hr>

            <a iconCls="icon-edit" href="modules/sjcj/villagejbxx/villagejbxx-view.jsp" trigger="single"
               target="dialog" rel="villagejbxx_view" title="查看村庄详情 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalvillage}}" width="930" height="600"
               buttons="[{method:'viewPrev',text:'查看上一条'},{method:'viewNext',text:'查看下一条'}]">查看</a>
            <hr>

            <a iconCls="icon-base icon-base-ban" trigger="single"
               target="confirm" rel="villagejbxx_remove" title="是否确定删除 {{naturalvillage}}？" id="village_remove_btn">删除</a>
            <hr>
            <a iconCls="icon-redo" trigger="none" target="custom" rel="villagejbxx_export">导出</a>

            <%--<hr>

            <a iconCls="icon-prev" trigger="none" target="custom" rel="villagejbxx_prev">上一步</a>

            <hr>
            <a iconCls="icon-next" trigger="none" target="custom" rel="villagejbxx_next">下一步</a>
--%>
        </div>
    </div>
        </div>
    </div>
</div>

<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        var unitcode = '<%=request.getParameter("unitCode")%>';
        requirejs([
            'core/filter/filter.dictionary',
            'modules/sjcj/villagejbxx/ctrl/villagejbxx','css!plugins/viewer/viewer.min.css'
        ], function (FilterDictionary,Villagejbxx) {
            FilterDictionary.add([
                'XZQH', 'villageType']).then(function () {
                window.Villagejbxx = new Villagejbxx('villagejbxx', panel);
                window.Villagejbxx.load(panel,unitcode);
            })
        });
    };

</script>
