define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var viewer = require('plugins/viewer/viewer.min');
    var VillagejbxxView = Page.extend(function () {

        var _self = this;
        var rid;//项目id，此为村庄主键vid
        var emodule = 3;//图片一级分类
        // @override
        this.load = function (panel, data) {
            _self = this;
            var form = panel.find('form');
          panel.siblings("div").eq(0).find(".panel-title").text("查看村庄详情" + data.districtcode + '-' +  data.town+ '-' +  data.administrativevillage+ '-' +  data.naturalvillage);
            /*Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (rlt) {
                if(rlt != null ){
                    panel.find("#village_xzqh_div").html(rlt.district);
                }
            });*/


            Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + data.vid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                _self.data = data;
                rid = data.vid;//村庄主键
                form.form('load', data)
                    .form('disableValidation')
                    .form('readonly', 'vid')
                    .form('focus');
                //村庄图片加载
                reloadImageView();
            });

            panel.find('#village_location').click(function() {
                var lng = _self.data.longit;
                var lat = _self.data.lat;
                if(lng == undefined || lng == "") {
                    lng = 0;
                }
                if(lat == undefined || lat == "") {
                    lat = 0;
                }
                $('#map_iframe_village').attr("src","../../modules/sjcj/map/locationmap.jsp?module=readonly&lng=" + lng + "&lat=" + lat);

                $('#village_map_dialog').dialog({
                    title: '村庄地点',
                    width: 900,
                    height: 600
                });
            });


        };

        function reloadImageView() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/'+emodule+'/' + rid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                for(var i = 1 ; i <= 7 ; i++){
                    $('#images'+emodule+'_'+i).empty();
                }
                $.each(data.fjList, function(index, item) {
                    $('<img>', {
                        src : "data:image/jpg;base64,"+item.efj,
                    }).css({
                        height : "100px",
                        margin : "3px"
                    }).appendTo(_self.panel.find('#images'+item.emodule+'_' + item.type1));
                });
                /*_self.panel.find('#images3_1').viewer({
                    zIndex : 9999
                });*/
                for(var i = 1 ; i <= 7 ; i++){
                    _self.panel.find('#images'+emodule+'_'+i).viewer({
                        zIndex : 9999
                    });
                }

            });
        }


      //上一户
      this.viewPrev = function (panel, data,closeCallback) {
        table = _self.parent.panel.find("#villagejbxx_table");
        var rows = table.datagrid("getRows");
        for(var i = 0 ; i < rows.length ; i++){
          var row = rows[i];
          if(row.vid == data.vid){
            if(i == 0){
              $.messager.alert('提醒', '已经是第一条数据！');
            } else {
              var showobj = rows[i-1];
              var form = panel.find('form');
              form.form('clear').form('disableValidation');
              this.load(panel,showobj);
            }
            break;
          }
        }
        return false;
      }

      //下一户
      this.viewNext = function (panel, data,closeCallback) {
        table = _self.parent.panel.find("#villagejbxx_table");
        var rows = table.datagrid("getRows");
        for(var i = 0 ; i < rows.length ; i++){
          var row = rows[i];
          if(row.vid == data.vid){
            if(i == (rows.length -1)){
              $.messager.alert('提醒', '已经是最后一条数据！');
            } else {
              var showobj = rows[i+1];
              var form = panel.find('form');
              form.form('clear').form('disableValidation');
              this.load(panel,showobj);
            }
            break;
          }
        }
        return false;
      }
    });

    return VillagejbxxView;
});
