define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Events = require('core/events');



    var VillagejbxxAdd = require('./villagejbxx.add');
    var VillagejbxxEdit = require('./villagejbxx.edit');
    var VillagejbxxView = require('./villagejbxx.view');
    var VillagejbxxRemove = require('./villagejbxx.remove');
    var VillagejbxxExport = require('./villagejbxx.export');


    // 业务信息
    var Villagejbxx = Page.extend(function () {
        var _self = this;
        this.injecte([
            new VillagejbxxAdd('villagejbxx_add'),
            new VillagejbxxEdit('villagejbxx_edit'),
            new VillagejbxxView('villagejbxx_view'),
            new VillagejbxxRemove('villagejbxx_remove'),
            new VillagejbxxExport('villagejbxx_export'),
          new VillagejbxxExport('villagejbxx_prev'),
          new VillagejbxxExport('villagejbxx_next'),

        ]);



        // @override
        this.load = function (panel,unitcode) {
            _self = this;
            var table = this.table = panel.find('table');

          //上一页
          panel.find("#villagejbxx_prev").on("click",function(){
            var url = Config.ContextPath + 'modules/sjcj/villagejbxx/division.jsp';
            Events.trigger('open.MenuTab', {
              id: 'aa',
              text: '选择行政村',
              url: url,
              closable: true
            });
          });
          //下一页
          panel.find("#villagejbxx_next").on("click",function(){
            var table = _self.panel.find('#villagejbxx_table');
            var rows = table.datagrid('getSelections');
            if(rows != null && rows.length > 0){
              var url = Config.ContextPath + 'modules/sjcj/farmhousejbxx/farmhousejbxx.jsp?vid=' + rows[0].vid;
              Events.trigger('open.MenuTab', {
                id: 'aa',
                text: '农房基础信息',
                url: url,
                closable: true
              });
            } else {
              $.messager.alert('提醒', '请在列表中选中一条村庄记录！');
            }
          });

            this.$autoHeight('north', $('#village-info-main', panel));
            var url = "service/sjcj/villagejbxx";
            //行政村不為空
            if(unitcode != null && unitcode != undefined && unitcode != 'undefined' && unitcode != '' && unitcode != 'null'){
                url += '?administrativevillage='+unitcode;
                panel.find("#administrativevillage").val(unitcode);
            }

            table.cdatagrid({
                controller: this,
                url: url
            });


            //根据权限设置操作按钮:镇级有新增、修改和删除按钮，管理员有修改和删除按钮
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function (rlt) {
                var isZj = false;
                var isAdmin = false;
                for (var i = 0; i < rlt.length; i++) {
                    if (rlt[i].roleCode == '0013') {
                        isZj = true;
                    }
                    if(rlt[i].roleCode == 'sysadmin'){
                        isAdmin = true;
                    }
                }
                if(isAdmin){
                    panel.find("#village_add_btn").parent("td").next().remove();
                    panel.find('#village_add_btn, #village_add_btn + hr', panel).remove();
                } else if (!isZj) {
                    panel.find("#village_add_btn").parent("td").next().remove();
                    panel.find('#village_add_btn, #village_add_btn + hr', panel).remove();
                    panel.find("#village_edit_btn").parent("td").next().remove();
                    panel.find('#village_edit_btn, #village_edit_btn + hr', panel).remove();
                    panel.find("#village_remove_btn").parent("td").next().remove();
                    panel.find('#village_remove_btn, #village_remove_btn + hr', panel).remove();
                }
            });

        };

    });

    return Villagejbxx;
});
