define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var VillagejbxxAdd = require('./villagejbxx.add');

    var VillagejbxxEdit = VillagejbxxAdd.extend(function () {
        var rid;//项目id，此为村庄主键vid
        var emodule = 3;//图片一级分类
        var _self;
        // @override
        this.load = function (panel, data) {
            _self = this;
            var form = panel.find('form');
            /*Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (rlt) {
                if(rlt != null ){
                    panel.find("#village_xzqh_div").html(rlt.district);
                }
            });*/
            /*Core.ajax(Config.ContextPath + 'service/common/getXZQHByLoginUser', {
                method: 'get'
            }).then(function(data) {
                panel.find("#village_xzqh_div").html(data[0].parentName + "-" + data[0].dataValue);
            });*/

            $('#village_location').click(function() {
                var lng = panel.find('#village_input_lng').val();
                var lat = panel.find('#village_input_lat').val();
                if(lng == undefined || lng == "") {
                    lng = panel.find("#village_input_htlng").val();
                }
                if(lat == undefined || lat == "") {
                    lat =  panel.find("#village_input_htlat").val();
                }
                $('#map_iframe_village').attr("src","../../modules/sjcj/map/locationmap.jsp?dialogname=village_map_dialog&module=village&lng=" + lng + "&lat=" + lat);

                $('#village_map_dialog').dialog({
                    title: '村庄地点',
                    width: 900,
                    height: 600
                });
            });

            Core.ajax(Config.ContextPath + 'service/sjcj/villagejbxx/' + data.vid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                _self.data = data;
                rid = data.vid;//村庄主键
                form.form('load', data)
                    .form('disableValidation')
                    .form('readonly', 'vid')
                    .form('focus');
                reloadImage();//村庄图片加载
                Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                    method: 'get'
                }).then(function(u_data) {
                    var unitManager = u_data.unitManager;
                    var lngAndlat = unitManager.split(",");
                    var htlng = lngAndlat[0];
                    var htlat = lngAndlat[1];
                    var lng = panel.find('#village_input_lng').val();
                    var lat = panel.find('#village_input_lat').val();
                    if (lng == undefined || lng == "" || lat == undefined || lat == "") {
                        panel.find("#village_input_htlng").textbox("setValue",htlng);
                        panel.find("#village_input_htlat").textbox("setValue",htlat);
                        markUnlocated();
                    } else {
                        markLocated();
                    }
                });
            });

            //村庄图片上传功能

            panel.find('#imagesbtn3_1').click(function () {
                showUploadDialog(1);
            });
            panel.find('#imagesbtn3_2').click(function () {
                showUploadDialog(2);
            });
            panel.find('#imagesbtn3_3').click(function () {
                showUploadDialog(3);
            });
            panel.find('#imagesbtn3_4').click(function () {
                showUploadDialog(4);
            });
            panel.find('#imagesbtn3_5').click(function () {
                showUploadDialog(5);
            });
            panel.find('#imagesbtn3_6').click(function () {
                showUploadDialog(6);
            });
            panel.find('#imagesbtn3_7').click(function () {
                showUploadDialog(7);
            });
        };

        function showUploadDialog(type1) {
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type='+emodule+'&rid=' + rid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage();
                }
            });
        }

        function reloadImage() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/'+emodule+'/' + rid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                for(var i = 1 ; i <= 7 ; i++){
                    $('#images'+emodule+'_'+i).empty();
                }
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#images'+item.emodule+'_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage();
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }
        // @override
        this.submit = function (panel, data, closeCallback) {
            var form = panel.find('form');
            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');

            if (isValid) {
                var obj = form.form("value");
                var regNumber = /^\d+(\.\d{1,8})?$/;
                var regInteger = /^\d+$/;
                var regLength = /^.{0,3000}$/;
                if (obj.longit === "" || obj.longit === undefined) {
                    $.messager.alert('提醒', '请定位村庄地点！');
                    return false;
                } else if (regInteger.test(obj.household) == false) {
                    $.messager.alert('提醒', '自然村户籍户数内容为数字！');
                    return false;
                } else if (regInteger.test(obj.population) == false) {
                    $.messager.alert('提醒', '自然村户籍人口内容为数字！');
                    return false;
                } /*else if (!regLength.test(obj.villageremark)) {
                    $.messager.alert('提醒', '村庄描述内容字符长度不能大于500！');
                    return false;
                }*/ else {
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/sjcj/villagejbxx/',
                        method: 'post',
                        data: data
                    }).then(closeCallback);
                }
            }

            return false;
        };

        // @override
        this.onClose = function (table) {
            table.datagrid('reload');
        };

        function markLocated() {
            $("#village_located").show();
            $("#village_unlocated").hide();
        }

        function markUnlocated() {
            $("#village_located").hide();
            $("#village_unlocated").show();
        }
    });

    return VillagejbxxEdit;
});
