define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    var VillagejbxxAdd = Page.extend(function () {

        var rid;//项目id
        var emodule = 3;//图片一级分类
        var _self;
        // @override
        this.load = function (panel, data) {
            rid = 0;
            var form = panel.find('form');

            $("#village_located").hide();
            $("#village_unlocated").show();
            //获取行政村编码
           var administrativevillage = this.parent.panel.find("#administrativevillage").val();


            _self = this;
            //获取登录用户行政区划信息
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (rlt) {
                if(rlt != null ){
                    panel.find("#village_districtcode").combobox("setValue",rlt.countyCode);
                    panel.find("#village_town").combobox("setValue",rlt.townCode);
                    panel.find("#village_xzqh_div").html(rlt.district);
                }
               //初始化有行政村，记录行政村并初始化行政村经纬度，无则初始化当前登录用户经纬度
               if(administrativevillage != null && administrativevillage != ""){
                panel.find("#village_administrativevillage").combobox("setValue",administrativevillage);
                 Core.ajax(Config.ContextPath + 'service/common/loadUnitinfoByUnitCode/' + administrativevillage, {
                   method: 'get'
                 }).then(function (unit) {
                    var unitManager = null;
                    if(unit != null){
                      unitManager = unit.unitManager;
                    } else if(rlt != null ) {
                      unitManager = rlt.unitManager;
                    }
                    if(unitManager != null){
                      var lngAndlat = unitManager.split(",");
                      var htlng = lngAndlat[0];
                      var htlat = lngAndlat[1];
                      var lng = $('#village_input_lng').val();
                      var lat = $('#village_input_lat').val();
                      if (lng == undefined || lng == "") {
                        panel.find("#village_input_htlng").textbox("setValue",htlng);
                      }
                      if (lat == undefined || lat == "") {
                        panel.find("#village_input_htlat").textbox("setValue",htlat);
                      }
                    }
                 })
               } else {
                  if(rlt != null){
                    var unitManager = rlt.unitManager;
                    var lngAndlat = unitManager.split(",");
                    var htlng = lngAndlat[0];
                    var htlat = lngAndlat[1];
                    var lng = $('#village_input_lng').val();
                    var lat = $('#village_input_lat').val();
                    if (lng == undefined || lng == "") {
                      panel.find("#village_input_htlng").textbox("setValue",htlng);
                    }
                    if (lat == undefined || lat == "") {
                      panel.find("#village_input_htlat").textbox("setValue",htlat);
                    }
                  }
               }
            });
            /*Core.ajax(Config.ContextPath + 'service/common/getXZQHByLoginUser', {
                method: 'get'
            }).then(function(data) {
                panel.find("#village_districtcode").combobox("setValue",data[0].extraCode);
                panel.find("#village_town").combobox("setValue",data[0].dataCode);
                panel.find("#village_xzqh_div").html(data[0].parentName + "-" + data[0].dataValue);
            });*/

            //选择行政村修改默认经纬度为行政村经纬度
            panel.find('#village_administrativevillage').combobox({
                onSelect: function (row) {
                    if(row != null && row.unitManager != null ){
                        var unitManager = row.unitManager;
                        var jwds = unitManager.split(",");
                        if(jwds.length >= 2){
                            panel.find("#village_input_htlng").textbox("setValue",jwds[0]);
                            panel.find("#village_input_htlat").textbox("setValue",jwds[1]);
                        }
                    }
                },
            });

            /*Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function(data) {
                var unitManager = data.unitManager;
                var lngAndlat = unitManager.split(",");
                var htlng = lngAndlat[0];
                var htlat = lngAndlat[1];
                var lng = $('#village_input_lng').val();
                var lat = $('#village_input_lat').val();
                if (lng == undefined || lng == "") {
                    panel.find("#village_input_htlng").textbox("setValue",htlng);
                }
                if (lat == undefined || lat == "") {
                    panel.find("#village_input_htlat").textbox("setValue",htlat);
                }
            });*/

            $('#village_location').click(function () {
                var lng = panel.find('#village_input_lng').val();
                var lat = panel.find('#village_input_lat').val();
                if (lng == undefined || lng == "") {
                    lng = panel.find("#village_input_htlng").val();
                }
                if (lat == undefined || lat == "") {
                    lat = panel.find("#village_input_htlat").val();
                }
                $('#map_iframe_village').attr("src", "../../modules/sjcj/map/locationmap.jsp?dialogname=village_map_dialog&module=village&lng=" + lng + "&lat=" + lat);

                $('#village_map_dialog').dialog({
                    title: '村庄地点',
                    width: 900,
                    height: 600
                });
            });

            //
            form.form('disableValidation')
                .form('focus');

            //村庄图片上传功能
            panel.find('#imagesbtn3_1').click(function () {
                showUploadDialog(1);
            });
            panel.find('#imagesbtn3_2').click(function () {
                showUploadDialog(2);
            });
            panel.find('#imagesbtn3_3').click(function () {
                showUploadDialog(3);
            });
            panel.find('#imagesbtn3_4').click(function () {
                showUploadDialog(4);
            });
            panel.find('#imagesbtn3_5').click(function () {
                showUploadDialog(5);
            });
            panel.find('#imagesbtn3_6').click(function () {
                showUploadDialog(6);
            });
            panel.find('#imagesbtn3_7').click(function () {
                showUploadDialog(7);
            });

        };

        function showUploadDialog(type1) {
            if(rid == 0){
                rid = uuid();
                _self.panel.find("#vid").val(rid);
            }
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type='+emodule+'&rid=' + rid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage();
                }
            });
        }

        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }

        function reloadImage() {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/'+emodule+'/' + rid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                for(var i = 1 ; i <= 7 ; i++){
                    $('#images'+emodule+'_'+i).empty();
                }
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#images'+item.emodule+'_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage();
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }

        var submitDosomething = function (panel, data, closeCallback,type) {
          var form = panel.find('form');
          // 开启校验
          form.form('enableValidation');
          var isValid = form.form('validate');

          if (isValid) {
            var obj = form.form("value");
            var regNumber = /^\d+(\.\d{1,8})?$/;
            var regInteger = /^\d+$/;
            var regLength = /^.{0,3000}$/;

            if (obj.longit === "" || obj.longit === undefined) {
              $.messager.alert('提醒', '请定位村庄地点！');
              return false;
            } else if (regInteger.test(obj.household) == false) {
              $.messager.alert('提醒', '自然村户籍户数内容为数字！');
              return false;
            } else if (regInteger.test(obj.population) == false) {
              $.messager.alert('提醒', '自然村户籍人口内容为数字！');
              return false;
            } /*else if (!regLength.test(obj.villageremark)) {
                    $.messager.alert('提醒', '村庄描述内容字符长度不能大于500！');
                    return false;
                }*/ else {
              form.form('ajax', {
                url: Config.ContextPath + 'service/sjcj/villagejbxx?type=new',
                method: 'post',
              }).then(function (data) {
                  if(type == 1){
                    closeCallback();
                  } else {
                    $.messager.alert('提醒', '新增成功！请继续增加！');
                    form.form('clear').form('disableValidation');
                    _self.load(panel,new Object());
                  }
              });
            }
          }
        }

        // @override
        this.submit = function (panel, data, closeCallback) {
          submitDosomething(panel,data,closeCallback,1);
          return false;
        };

        this.submitNext = function (panel, data, closeCallback) {
          submitDosomething(panel,data,closeCallback,2);
          return false;
        };


        // @override
        this.onClose = function (table, data) {
            table.datagrid('reload');
        };
    });

    return VillagejbxxAdd;
});
