$(function () {
    define(function (require) {
        var Config = require('config');
        var Core = require('core/core');
        var Page = require('core/page');
        var Events = require('core/events');

        var VillagejbxxAdd = require('./villagejbxx.add');
        var VillagejbxxEdit = require('./villagejbxx.edit');
        var VillagejbxxView = require('./villagejbxx.view');
        var VillagejbxxRemove = require('./villagejbxx.remove');
        var VillagejbxxExport = require('./villagejbxx.export');

        // 业务信息
        var Division = Page.extend(function () {
            this.injecte([
                new VillagejbxxAdd('villagejbxx_add'),
                new VillagejbxxEdit('villagejbxx_edit'),
                new VillagejbxxView('villagejbxx_view'),
                new VillagejbxxRemove('villagejbxx_remove'),
                new VillagejbxxExport('villagejbxx_export')
            ]);

            this.load = function (panel, data) {
                //去掉加载效果
                $(".ajax-loader-icon").parent("div").hide();
              //根据权限设置操作按钮
              Core.ajax(Config.ContextPath + 'service/common/getLoginUserRoles', {
                method: 'get'
              }).then(function (rlt) {
                var isZj = false;//是否为镇级用户
                for (var i = 0; i < rlt.length; i++) {
                  if (rlt[i].roleCode == '0013') {
                    isZj = true;
                    break;
                  }
                }
                if (isZj) {
                  //根据当前镇级登录用户获取下级行政村列表，补充自然村数量、农房数量
                  Core.ajax(Config.ContextPath + 'service/analysis/getNumByUintcode', {
                    method: 'get',
                    type: 'json'
                  }).then(function (rlt) {
                    if (rlt != null) {
                      for(var i = 0 ; i < rlt.length ; i++){
                        var item = rlt[i];
                        var $html = $('<li ids='+item.unitCode+'>\n' +
                          '                    <a>\n' +
                          '                        <dl>\n' +
                          '                            <dt>' + item.unitName + '</dt>\n' +
                          '                            <dd>自然村数量:<span>' + item.zrcnums + '</span></dd>\n' +
                          '                            <dd>农房数量&nbsp;&nbsp;&nbsp;:<span>' + item.nfnums + '</span></dd>\n' +
                          '                        </dl>\n' +
                          '                    </a>\n' +
                          '                </li>');
                        $(".cy-division-content ul").append($html);
                        if(item.zrcnums != 0){
                          $html.addClass("active");
                        };
                      }
                    }
                  });
                } else {
                  panel.find("#division_tx").html("非镇级用户，不可选择行政村填报！");
                }
              });


                $(".cy-division-content").on("click", "li", function () {
                    var unitCode = $(this).attr("ids");
                    var url = Config.ContextPath + "modules/sjcj/villagejbxx/villagejbxx.jsp?unitCode=" + unitCode;
                    Events.trigger('open.MenuTab', {
                        id: 'aa',
                        text: '当前村庄信息',
                        url: url,
                        closable: true
                    }, false);
                })
            }

        });


        return Division;
    });
})
