define(function(require){
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var echarts = require('js/echarts/echarts.min');
    var Villagestj=Page.extend(function(){

        var self ;
        var usercode;
        this.load =function(panel,data){
            self=this;
            Core.ajax(Config.ContextPath+'service/common/getLoginUser', {
                method: 'get'
            }).then(function(rlt) {
                usercode= rlt.userUnits[0].unitCode;
                //alert(usercode);
                Core.ajax(Config.ContextPath+'service/analysis/searchallvillage/'+usercode,{
                    type: 'json',
                    method: 'get'
                }).then(function (data) {
                    var citynums=[];
                    var brower = [];
                    for(var i=0;i<data.length;i++){
                        citynums.push(data[i].cityname);
                        brower.push({
                            value: data[i].num,
                            name: data[i].cityname
                        });
                    }
                    /*   brower=[
                           {value:900, name:'南京市'},
                           {value:600, name:'无锡市'},
                           {value:450, name:'徐州市'},
                           {value:300, name:'常州市'},
                           {value:800, name:'苏州市'},
                           {value:500, name:'南通市'},
                           {value:500, name:'连云港市'},
                           {value:220, name:'淮安市'},
                           {value:500, name:'盐城市'},
                           {value:500, name:'扬州市'},
                           {value:460, name:'镇江市'},
                           {value:500, name:'泰州市'},
                           {value:500, name:'宿迁市'},
                       ]*/
                    myChart.setOption({
                        series: [{
                            data: brower
                        }],
                        xAxis: {
                            data:citynums
                        }
                    });
                    var table=panel.find('table');
                    table.cdatagrid({
                        // 必须要加此项!!
                        controller :self
                    }).datagrid('loadData', data);
                });
                // 基于准备好的dom，初始化echarts实例
                var myChart = echarts.init(document.getElementById('mains'));
                // 指定图表的配置项和数据
                var option = {
                    tooltip : {
                        trigger: 'axis',
                        axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                            type : 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                        }
                    },
                    toolbox: {
                        show: true,
                        x:500,
                        y:20,
                        feature: {
                            /* saveAsImage: {show: true}*/
                        }
                    },
                    grid: {//容器定位
                        left: 0,
                        right: 0,
                        top:'10%',
                        bottom: '10%',
                        containLabel: true
                    },
                    xAxis : [
                        {
                            type : 'category',
                            splitLine: { //网格线
                                show: false
                            },
                            data : [],
                            axisLabel:{//X轴坐标数据全显示
                                interval:0,
                            },
                            axisTick: {
                                alignWithLabel: true,
                                //show: false  坐标轴刻度
                            }
                        }
                    ],
                    yAxis : [
                        {
                            type : 'value',
                            splitLine: { //网格线
                                show: false
                            }
                        }
                    ],
                    series : [
                        {
                            name:'村庄数',
                            type:'bar',
                            barWidth: 50,
                            label: {
                                normal: {
                                    show: true,
                                    position: 'top'
                                }
                            },
                            itemStyle:{
                                normal:{
                                    color: function(params) {
                                        // build a color map as your need. 柱状图颜色
                                        /*var colorList = ['#52918F','#FF403C', '#FF772D', '#00A8FF',
                                            '#FFAA17','#63B8FF','#FCDC57','#CBD570',
                                            '#FEA891','#8EE5EE','#F6BF75','#8FD2E7','#1874CD'
                                        ];*/
                                        /*var colorList = ['#52918F','#00AEAE','#019858','#1BBE96','#FF403C','#FF5151','#D7504B','#FF772D','#FFAA17','#F3A43B','#077BFF','#2828FF','#46A3FF'];*/
                                        var colorList = ['#37A2DA','#32C5E9','#9FE6B8','#FFDB5C','#FF9F7F','#FB7293','#E7BCF3','#37A2DA','#32C5E9','#9FE6B8','#FFDB5C','#FF9F7F','#FB7293','#E7BCF3'];
                                        return colorList[params.dataIndex]

                                    },
                                }
                            },
                            data:[]
                        }
                    ]
                };

                // 使用刚指定的配置项和数据显示图表。
                myChart.setOption(option);
            });


        };

    });
    return Villagestj;
});