define(function(require){
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var echarts = require('js/echarts/echarts.min');
    var Farmhousetj=Page.extend(function(){
        var self ;
        var years;
        this.load =function(panel,data){
            self=this;
            loadData();
            panel.find('#farmhousetj_search').click(function () {
                 var year=document.getElementById('search_year').value;
                  loadData(year);
            })
        };

        var loadData = function (year) {
            var table = self.panel.find('#farmhousetj_id');
            var  url = Config.ContextPath + 'service/analysis/searchallfarmshouse';
            if(year != null && year != ''){
                url += "?year=" + year;
            }
            Core.ajax(url, {
                type: 'json',
                method: 'get'
            }).then(function (rlt) {
                rlt=[{"Fnum":12000,"Tnum":11000,"Tpercentage":32,"Fpercentage":"68%","cityname":"南京市","num":23000},
                    {"Fnum":8000,"Tnum":10000,"Tpercentage":32,"Fpercentage":"68%","cityname":"无锡市","num":25},
                    {"Fnum":23000,"Tnum":21000,"Tpercentage":32,"Fpercentage":"68%","cityname":"徐州市","num":25},
                    {"Fnum":17000,"Tnum":16000,"Tpercentage":32,"Fpercentage":"68%","cityname":"常州市","num":25},
                    {"Fnum":16000,"Tnum":11000,"Tpercentage":32,"Fpercentage":"68%","cityname":"苏州市","num":25},
                    {"Fnum":33000,"Tnum":31000,"Tpercentage":32,"Fpercentage":"68%","cityname":"南通市","num":25},
                    {"Fnum":24000,"Tnum":21000,"Tpercentage":32,"Fpercentage":"68%","cityname":"连云港市","num":25},
                    {"Fnum":34000,"Tnum":31000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"淮安市","num":26},
                    {"Fnum":25000,"Tnum":21000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"盐城市","num":26},
                    {"Fnum":21000,"Tnum":19000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"扬州市","num":26},
                    {"Fnum":9500,"Tnum":8000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"镇江市","num":26},
                    {"Fnum":24000,"Tnum":21000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"泰州市","num":26},
                    {"Fnum":34000,"Tnum":31000,"Tpercentage":34.62,"Fpercentage":"65.38%","cityname":"宿迁市","num":26}];
                for(var i = 0 ; i < rlt.length ; i++){
                    var obj = rlt[i];
                    obj.num = obj.Fnum+obj.Tnum;
                    obj.Tpercentage = (obj.Tnum/obj.num*100).toFixed(2);
                    obj.Fpercentage = (obj.Fnum/obj.num*100).toFixed(2);
                }
                echartsHjs(rlt);
                _createData(table,rlt);
            });
        }


        // 列表信息
        function _createData(table, data) {
            table.cdatagrid({
                // 必须要加此项!!
                controller :self
            }).datagrid('loadData', data);
        };

        //村庄户籍数统计echart图表形成方法，list :数据
        function echartsHjs(list){
            //数据处理
            var xData = new  Array();
            var wgsData = new Array();
            var ygsData = new Array();
            var gslData = new Array();
            for(var i = 0 ; i < list.length ; i++){
                var obj = list[i];
                xData[i] = obj.cityname;
                wgsData[i] = obj.Fnum;
                ygsData[i] = obj.Tnum;
                gslData[i] = obj.Tpercentage;
            }
            var myChart = echarts.init(document.getElementById('farmhousetj_main'));
            var colors = [ '#37A2DA','#32C5E9', '#E7BCF3'];
            option = {
                color: colors,
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                        type : 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                    }
                },
                legend: {
                    x: '750px',
                    y:'14px',
                    data:['未改善','已改善','改善率'],
                    right:20,
                },
                grid: {
                    left: '1%',
                    right: '8%',
                    bottom: '15%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : xData,
                        axisLabel:{//X轴坐标数据全显示
                            interval:0,
                            rotate:-28
                        },
                        axisTick: {
                            alignWithLabel: true,
                            //show: false  坐标轴刻度
                        }
                    }
                ],
                yAxis : [
                    {
                        type: 'value',
                        name: '数量(个)',
                        splitLine:{
                            show:false
                        }
                    },
                    {
                        type: 'value',
                        name: '百分比(%)',
                        min: 0,
                        max: 100,
                        position: 'right',
                        splitLine:{
                            show:false
                        }
                    }
                ],
                series : [
                    {
                        name:'未改善',
                        type:'bar',
                        barWidth :50,
                        stack: 'k',
                        data:wgsData,
                    },
                    {
                        name:'已改善',
                        type:'bar',
                        stack: 'k',
                        data:ygsData,
                        label: {
                            normal: {
                                show: true,
                                position: 'top',
                                formatter:function (name) {
                                    return list[name.dataIndex].Tnum + list[name.dataIndex].Fnum ;
                                }
                            }
                        },
                    },
                    {
                        name:'改善率',
                        type:'line',
                        data:gslData,
                        yAxisIndex: 1,
                    }
                ]
            };
            myChart.setOption(option);
        }
    });
    return Farmhousetj;
});