<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<div class="easyui-layout" data-options="fit:true">
    <div class="easyui-layout unit-info-main" fit="true">
        <div region="north" border="false" style="height: 60px; padding: 4px;">
            <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
                <form class="clearFromValue">
                    <div class="search-item">
                        <label>关联实体</label>
                        <input class="easyui-textbox" name="s_wid" />
                    </div>

                    <a class="easyui-linkbutton btn-search" iconCls="icon-search" id="farmhouse_search">查询</a>
                    <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
                </form>
            </div>
        </div>

        <div region="center" border="false" style="padding: 4px;">
            <table  fitColumns="true"
                    fit="true"
                    id="pmpWfRecord_table"
                    idField="worder"
                    sortName="updatetime"
                    sortOrder="desc"
                    search=".search"
                    toolbar=".temp-toolbar" action="test_view">
                <thead>
                <tr>
                    <th data-options="field:'wmodule'" >功能模块</th>
                    <th data-options="field:'wid'" >关联实体ID</th>
                    <th data-options="field:'worder'">记录序号</th>
                    <th data-options="field:'status'">记录状态</th>
                    <th data-options="field:'username'">办理人员</th>
                    <th data-options="field:'unitcode'">部门</th>
                    <th data-options="field:'ideaCode'">办理结果</th>
                    <th data-options="field:'wcontent'" >办理内容</th>
                    <th data-options="field:'wdate'" format="Date:yyyy-MM-dd">更改时间</th>
                </tr>
                </thead>
            </table>
            <div class="temp-toolbar">
                <a iconCls="icon-add" href="modules/sjcj/test/test-info.jsp" trigger="none" id="add_btn"
                   target="dialog" rel="pmpWfRecord_add" title="新增流程" width="900" height="640" btnValue="添加">新增</a>
                <hr>

                <a iconCls="icon-edit" href="modules/sjcj/test/test-info.jsp" trigger="single" id="edit_btn"
                   target="dialog" rel="pmpWfRecord_edit" title="编辑 {{text}}" width="900" height="640"  buttons="[{method:'submit',text:'保存'}]" >修改</a>
                <hr>

                <a iconCls="icon-edit" href="modules/sjcj/test/test-info.jsp" trigger="single"
                   target="dialog" rel="pmpWfRecord_view" title="查看 {{text}}" width="900" height="640" buttons="[{method:'submit',text:'查看'}]">查看</a>
                <hr>
                <a iconCls="icon-base icon-base-ban" trigger="single" id="del_btn"
                   target="confirm" rel="pmpWfRecord_remove" title="是否确定删除 {{text}}？">删除</a>
            </div>
        </div>
    </div>
</div>

<script>
    $.parser.onComplete = function(panel) {
        $.parser.onComplete = $.noop;
        requirejs([
                'modules/sjcj/test/ctrl/test'],
            function (PmpWfRecord) {
                new PmpWfRecord('PmpWfRecord',panel).load(panel);
            });
    };
</script>
