define(function(require){
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var echarts = require('js/echarts/echarts.min');
    var PmpWfRecord=Page.extend(function(){


        this.load =function(panel,data){

            Core.ajax(Config.ContextPath+'service/analysis/searchallvillage/',{
                type: 'json',
                method: 'get'
            }).then(function (data) {
                var result=$.parseJSON(data);
                //alert(result.length);
                var citynums=[];
                var brower = [];
                for(var i=0;i<result.length;i++){
                    citynums.push(result[i].cityname);
                    brower.push({
                        value: result[i].num,
                        name: result[i].cityname
                    });
                   //alert(citynums);
                }
                myChart.setOption({
                    series: [{
                        data: brower
                    }],
                    legend: {
                        data:citynums
                    }
                    });

                /*form.form('load', data)
                    .form('disableValidation')
                    .form('focus');*/
            });


            // 基于准备好的dom，初始化echarts实例
            var myChart = echarts.init(document.getElementById('main'));
            // 指定图表的配置项和数据
            var option = {
                title : {
                    text: '村庄数统计信息',
                    x:'center'
                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient : 'vertical',
                    x : 'left',
                    data:[]
                },
                toolbox: {
                    show : true,
                    feature : {
                        mark : {show: true},
                        dataView : {show: true, readOnly: false},
                        magicType : {
                            show: true,
                            type: ['pie', 'funnel'],
                            option: {
                                funnel: {
                                    x: '25%',
                                    width: '50%',
                                    funnelAlign: 'left',
                                    max: 1548
                                }
                            }
                        },
                        restore : {show: true},
                        saveAsImage : {show: true}
                    }
                },
                calculable : true,
                series : [
                    {
                        name:'访问来源',
                        type:'pie',
                        radius : '55%',
                        center: ['50%', '60%'],
                        data:[]
                    }
                ]
            };

            // 使用刚指定的配置项和数据显示图表。
            myChart.setOption(option);
        };

    });
    return PmpWfRecord;
});