<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="statistics-info-main2">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <input type="hidden" name="s_stype" id="statis_s_stype2"/>
            <form class="clearFromValue"  id="statistics_search_form2">
                <div class="search-item">
                    <label>状态</label>
                    <input class="easyui-combobox" name="s_status"
                           target="dictionary"
                           key="sjcjStatusType" style="width: 150px;"/>
                </div>
                <div class="search-item">
                    <label>年份</label>
                    <input type="text" class="easyui-combobox" name="s_syear" style="width: 80px;"
                           url="service/common/getYearList/10" method="get" data-options="valueField:'year',textField:'year'"/>
                </div>
                <div class="search-item">
                    <label>属地</label>
                    <input type="text" class="easyui-combotree"
                           url="service/common/getXZQHByLoginUser" method="get"
                           data-options="valueField:'dataCode',textField:'dataValue',parentField:'extraCode'"
                           name="s_towns"/>
                </div>

                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>
                <a class="easyui-linkbutton btn-reset" iconcls="icon-reload">清空查询条件</a>
                &nbsp;&nbsp;<a href="#" id="statisticsList2_a_lct">点击查看流程图</a>
                <input type="hidden" id="dqRoleCode2" >
            </form>
        </div>
    </div>

    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table fit="true"
               fitColumns="true"
               idField="sid"
               sortName="updateTime"
               sortOrder="desc"
               search=".search"
               toolbar=".temp-toolbar" action="statisticsList2_view" id="statisticstables2">
            <thead>
            <tr>
                <th data-options="field:'sid'"  hidden="true">id</th>
                <th data-options="field:'status', width:'7'"  format="Dictionary:sjcjStatusType" align="center">状态</th>
                <th data-options="field:'syear', width:'7'" align="center">年份</th>
                <th data-options="field:'districtcode', width:'12'" align="center">行政区划</th>
                <th data-options="field:'town', width:'10'"  align="center">乡镇</th>
                <th data-options="field:'administrativevillage', width:'10'"  align="center">行政村名</th>
                <th data-options="field:'naturalVillage', width:'10'"  align="center">自然村名</th>
                <th data-options="field:'username', width:'8'" align="center">录入用户</th>
                <th data-options="field:'updateTime', width:'8'" format="Date:yyyy-MM-dd" align="center">更新时间</th>
            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">
            <a iconCls="icon-edit" trigger="single"  id="statisticsList2_cxdr_btn"
               target="confirm" rel="statisticsList2_cxdr" title="是否确定重新导入数据？<br>重新导入后原数据将删除，重新录入基础填报表数据!">重新导入</a>
            <hr>
            <a iconCls="icon-edit" trigger="single"  id="statisticsList2_rqsj_btn"
               target="confirm" rel="statisticsList2_rqsj" title="是否确定数据？<br>确认数据后可对数据进行校验修改后提交。">确定数据</a>
            <hr>
            <a iconCls="icon-edit" trigger="single"  id="statisticsList2_tj_btn"
               target="confirm" rel="statisticsList2_tj" title="是否确定提交？">提交</a>
            <hr>
            <a iconCls="icon-base icon-sl" trigger="single" href="modules/sjcj/statisticsList2/statisticsList2-opinion.jsp"
               target="dialog" rel="statisticsList2_opinion_sl" title="受理  {{text}}" width="550" height="300" id="statisticsList2_sl_btn">受理</a>
            <hr>

            <a iconCls="icon-base icon-th" trigger="single" href="modules/sjcj/statisticsList2/statisticsList2-opinion.jsp"
               target="dialog" rel="statisticsList2_opinion_th" title="退回 {{text}}" width="550" height="300" id="statisticsList2_th_btn">退回</a>
            <hr>
            <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics2/farmHouseStatistics2.jsp" trigger="single"
               target="dialog" rel="statisticsList2_view"
               title="实际农改信息详情 {{districtcode}}-{{town}}-{{administrativevillage}}-{{naturalVillage}} " width="1300" height="600" buttons="[{method:'submit',text:'查看'}]">实际农改信息详情</a>
            <hr>
            <a iconCls="icon-redo" trigger="none" target="custom" rel="statisticsList2_exp">导出</a>
            <hr>

        </div>


    </div>
</div>
<script>
    $.parser.onComplete = function(panel) {
        $.parser.onComplete = $.noop;
        var stype = '<%=request.getParameter("stype")%>';
        var _sjs = Math.random();
        requirejs([
                'modules/sjcj/statisticsList2/ctrl/statisticsList2',
                'core/filter/filter.dictionary'],
            function (StatisticsList2, FilterDictionary) {

                FilterDictionary.add([
                    'sjcjStatusType','XZQH','BetterType','PersonType','operations']
                ).then(function () {
                    window.StatisticsList2 = new StatisticsList2('statisticsList2'+_sjs, panel);
                    window.StatisticsList2.load(panel, stype);
                });
            });
    };
</script>
