define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var FarmHouseStatistics2View = require('../../farmHouseStatistics2/ctrl/farmHouseStatistics2');
    var StatisticsList2Opinionsl = require('./statisticsList2.opinion.sl');
    var StatisticsList2Opinionth = require('./statisticsList2.opinion.th');
    var StatisticsList2Opiniontj = require('./statisticsList2.opinion.tj');
    var StatisticsList2Rqsj = require('./statisticsList2.rqsj');
    var StatisticsList2Cxdr = require('./statisticsList2.cxdr');
    var StatisticsList2Exp = require('./statisticsList2.exp');

    var StatisticsList2 = Page.extend(function () {
        this.injecte([
            new FarmHouseStatistics2View('statisticsList2_view'),
            new StatisticsList2Opinionsl('statisticsList2_opinion_sl'),
            new StatisticsList2Opinionth('statisticsList2_opinion_th'),
            new StatisticsList2Opiniontj('statisticsList2_tj'),
            new StatisticsList2Rqsj('statisticsList2_rqsj'),
            new StatisticsList2Cxdr('statisticsList2_cxdr'),
            new StatisticsList2Exp('statisticsList2_exp'),

        ]);

        // @override
        this.load = function (panel, stype) {
            if (stype != null && stype != '' && stype != 'null'){
                panel.find("#statis_s_stype2").val(stype);


            }
            var table = this.table = panel.find('table');
            this.$autoHeight('north', $('#statistics-info-main2', panel));
            var url = "service/common/statisticsList?stype="+stype;
            table.cdatagrid({
                controller: this,
                url: url,
            });

            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isZj = false;
                var isSXj = false;
                panel.find("#dqRoleCode2").val(rlt[1].roleCode);
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'||rlt[i].roleCode == '0012'||rlt[i].roleCode == '0011'){
                        isZj = true;
                        break;
                    }
                    if(rlt[i].roleCode == '0013'){
                        isSXj = true;
                        break;
                    }
                }
                if(isZj){
                    $('#statisticsList2_cxdr_btn').parent('td').next().remove();
                    $('#statisticsList2_cxdr_btn, #statisticsList2_cxdr_btn + hr', panel).remove();
                    $('#statisticsList2_tj_btn').parent('td').next().remove();
                    $('#statisticsList2_tj_btn, #statisticsList2_tj_btn + hr', panel).remove();
                    $('#statisticsList2_rqsj_btn').parent('td').next().remove();
                    $('#statisticsList2_rqsj_btn, #statisticsList2_rqsj_btn + hr', panel).remove();
                }
                if(isSXj){
                    $('#statisticsList2_sl_btn').parent('td').next().remove();
                    $('#statisticsList2_sl_btn, #statisticsList2_sl_btn + hr', panel).remove();
                    $('#statisticsList2_th_btn').parent('td').next().remove();
                    $('#statisticsList2_th_btn, #statisticsList2_th_btn + hr', panel).remove();
                }
            });
            panel.off('click', '#statisticsList2_a_lct');
            panel.on('click', '#statisticsList2_a_lct', function () {
                window.open("../../templatefile/信息统计流程图.jpg");
            });
        };

    });

    return StatisticsList2;
});

