<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="statistics-info-main">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <input type="hidden" name="s_stype" id="statis_s_stype"/>
            <form class="clearFromValue" id="statistics_search_form">
                <div class="search-item">
                    <label>状态</label>
                    <input class="easyui-combobox" name="s_status"
                           target="dictionary"
                           key="sjcjStatusType" style="width: 150px;"/>
                </div>
                <div class="search-item">
                    <label>年份</label>
                    <input type="text" class="easyui-combobox" name="s_syear" style="width: 80px;"
                           url="service/common/getYearList/10" method="get"
                           data-options="valueField:'year',textField:'year'"/>
                </div>
                <%--<div class="search-item">
                    <label>属地</label>
                    <input type="text" class="easyui-combotree"
                           url="service/common/getXZQHByLoginUser" method="get"
                           data-options="valueField:'dataCode',textField:'dataValue',parentField:'extraCode'"
                           name="s_towns"/>
                </div>--%>

                <div class="search-item">
                    <label>行政区划</label>
                    <!--江苏省-->
                    <div style="display: none">
                        <input type="text" class="easyui-combobox" name="first"  data-options="valueField: 'value',textField: 'label', data: [{label: '江苏省',value: '320000000000'}]"
                               method="get" prompt="省" value="320000000000" validType="true" />
                    </div>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="second" id="user_second" method="get" prompt="市"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="districtcode" id="user_third" method="get" prompt="县区"/>
                    &nbsp;
                    <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="town" id="user_fourth" method="get" prompt="镇"/>
                </div>


                <a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>

                &nbsp;&nbsp;<%--<a href="#" id="statisticsList_a_lct">点击查看流程图</a>--%>
                <br>
                <a class="warnSelf">说明：一个镇一年只能新建一条年度计划和年度实际改善情况总表，新建年度计划表时自动生成对应年度实际改善情况表，改善过程跟踪时确认改善的农房信息自动列入实际改善情况表中。<br>
                   镇级用户确认农改信息后可提交年度表(年度计划表和年度实际改善表)，县区、市、省级用户自下而上逐级审核，省级用户审核通过实际改善情况表后，列入表中的农房改善进度变为已改善。</a>
                <input type="hidden" id="dqRoleCode" name="dqRoleCode">
            </form>
        </div>
    </div>
    <div class="cy-btn-position" id="statisticsList_next1" style="display: none">
        <a class="easyui-linkbutton cy-btn cy-btn-forward" id="statisticsList1_prev">上一步：改善任务下发</a>
        <a class="easyui-linkbutton cy-btn cy-btn-next"  id="statisticsList1_next">下一步：改善过程跟踪</a>
    </div>
    <div class="cy-btn-position" id="statisticsList_next2" style="display: none">
        <a class="easyui-linkbutton cy-btn cy-btn-forward" id="statisticsList2_prev">上一步：改善过程跟踪</a>
        <a class="easyui-linkbutton cy-btn cy-btn-next"  id="statisticsList2_next">下一步：返回主页面</a>
    </div>
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table fit="true"
               fitColumns="true"
               idField="sid"
               sortName="updateTime"
               sortOrder="desc"
               search=".search"
               toolbar=".temp-toolbar" action="statisticsList_view" id="statisticstables">
            <thead>
            <tr>
                <th data-options="field:'status'" format="Dictionary:sjcjStatusType" align="center" width="15%">状态</th>
                <th data-options="field:'snum'" align="center" width="15%">农房数量</th>
                <th data-options="field:'syear'" align="center" width="15%">年份</th>
                <th data-options="field:'districtcode'" align="center" width="20%">行政区划</th>
                <th data-options="field:'town'" align="center" width="19%">乡镇</th>
                <th data-options="field:'username'" align="center" width="15%">录入用户</th>
                <th data-options="field:'updateTime'" format="Date:yyyy-MM-dd" align="center" width="15%">更新时间</th>
            </tr>
            </thead>
        </table>

        <div class="temp-toolbar">
            <a iconCls="icon-add" href="modules/sjcj/statisticsList/statisticsList-info.jsp" trigger="none"
               id="farmhousejbxx_add_btn"
               target="dialog" rel="statisticsList_add" title="新增年度计划" width="300" height="400"
               btnValue="添加">新增年度计划</a>
            <hr>
            <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics/farmHouseStatistics.jsp" trigger="single"
               target="dialog" rel="statisticsList_view" id="statisticsList_view_btn"
               title="计划改善农房 {{syear}}-{{districtcode}}-{{town}}" width="1300"
               height="600"buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">添加改善农房</a>
            <hr>
            <a iconCls="icon-edit" href="modules/sjcj/farmHouseStatistics/farmHouseStatistics.jsp" trigger="single"
               target="dialog" rel="statisticsList_view2" id="statisticsList_view2_btn"
               title="实际改善农房 {{syear}}-{{districtcode}}-{{town}}" width="1300"
               height="600" buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">查看农房实际改善信息</a>
            <hr>
            <a iconCls="icon-edit" trigger="single" id="statisticsList_tj_btn"
               target="confirm" rel="statisticsList_tj" title="是否确定提交？">提交计划</a>
            <hr>
            <a iconCls="icon-base icon-sl" trigger="single"
               href="modules/sjcj/statisticsList/statisticsList-opinion.jsp"
               target="dialog" rel="statisticsList_opinion_sl" title="受理  {{text}}" width="550" height="300"
               id="statisticsList_sl_btn">受理</a>
            <hr>

            <a iconCls="icon-base icon-th" trigger="single"
               href="modules/sjcj/statisticsList/statisticsList-opinion.jsp"
               target="dialog" rel="statisticsList_opinion_th" title="退回 {{text}}" width="550" height="300"
               id="statisticsList_th_btn">退回</a>
            <hr>

            <a iconCls="icon-redo" trigger="none" target="custom" rel="statisticsList_exp" id="statisticsList_exp_btn">导出</a>
            <hr>
            <a iconCls="icon-add" trigger="single"
               href="modules/sjcj/statisticsList/statisticsList-gs.jsp"
               target="dialog" rel="statisticsList_opinion_gs" title="农房改善公示 {{text}}" width="550" height="300"
               id="statisticsList_gs_btn">农房改善公示</a>
            <hr>
        </div>


    </div>
</div>
<input style="display: none"id="tmpstyle"/>
<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        var stype = '<%=request.getParameter("stype")%>';
        $("#tmpstyle").val(stype);
        requirejs([
                'modules/sjcj/statisticsList/ctrl/statisticsList',
                'core/filter/filter.dictionary'],
            function (StatisticsList, FilterDictionary) {
                FilterDictionary.add([
                    'sjcjStatusType', 'XZQH', 'BetterType', 'PersonType', 'operations','isBetter']
                ).then(function () {
                    window.StatisticsList = new StatisticsList('statisticsList', panel);
                    window.StatisticsList.load(panel, stype);
                   /* window.StatisticsListExp = new StatisticsListExp('statisticsList_exp', panel);
                    window.StatisticsListExp.submit(panel, stype);*/
                });
            });
    };
</script>
