define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var FarmHouseStatisticsView = require('../../farmHouseStatistics/ctrl/farmHouseStatistics');
    var StatisticsListOpinionsl = require('./statisticsList.opinion.sl');
    var StatisticsListOpinionth = require('./statisticsList.opinion.th');
    var StatisticsListOpiniontj = require('./statisticsList.opinion.tj');
    var StatisticsListOpinionGs = require('./statisticsList.opinion.gs');
    /*var StatisticsListRqsj = require('./statisticsList.rqsj');*/
    /*var StatisticsListCxdr = require('./statisticsList.cxdr');*/
    var StatisticsListExp = require('./statisticsList.exp');

    var StatisticsListAdd = require('./statisticsList.add');
    var Events = require('core/events');

    var StatisticsList = Page.extend(function () {
        this.injecte([
            new FarmHouseStatisticsView('statisticsList_view'),
            new FarmHouseStatisticsView('statisticsList_view2'),
            new StatisticsListOpinionsl('statisticsList_opinion_sl'),
            new StatisticsListOpinionth('statisticsList_opinion_th'),
            new StatisticsListOpinionGs('statisticsList_opinion_gs'),
            new StatisticsListOpiniontj('statisticsList_tj'),
            /*new StatisticsListRqsj('statisticsList_rqsj'),*/
            /*new StatisticsListCxdr('statisticsList_cxdr'),*/
            new StatisticsListExp('statisticsList_exp'),
            new StatisticsListAdd('statisticsList_add'),
        ]);

        // @override
        this.load = function (panel, stype) {
            var table = this.table = panel.find('table');
            this.$autoHeight('north', $('#statistics-info-main', panel));

          //计划：上一页
          panel.find("#statisticsList1_prev").on("click",function(){
            var url = Config.ContextPath + 'modules/task/task.jsp'
            Events.trigger('open.MenuTab', {
              id: 'aa',
              text: '改善任务下发',
              url: url,
              closable: true
            });
          });

          //计划：下一页
          panel.find("#statisticsList1_next").on("click",function(){
            var url = Config.ContextPath + 'modules/sjcj/farmhousejbxx/farmhousejbxx-gs.jsp'
            Events.trigger('open.MenuTab', {
              id: 'aa',
              text: '改善过程跟踪',
              url: url,
              closable: true
            });
          });

          //实际：上一页
          panel.find("#statisticsList2_prev").on("click",function(){
            var url = Config.ContextPath + 'modules/sjcj/farmhousejbxx/farmhousejbxx-gs.jsp'
            Events.trigger('open.MenuTab', {
              id: 'aa',
              text: '改善过程跟踪',
              url: url,
              closable: true
            });
          });

          //实际：下一页
          panel.find("#statisticsList2_next").on("click",function(){
            Events.trigger('close.MenuTab', 'aa');
          });

            var url = "service/common/statisticsList?s_stype=" + stype;
            table.cdatagrid({
                controller: this,
                url: url,
            });
            if(stype == 2){//实际改善隐藏新增、计划农房按钮
                panel.find('#farmhousejbxx_add_btn').parent('td').next().remove();
                panel.find('#farmhousejbxx_add_btn, #farmhousejbxx_add_btn + hr', panel).remove();
                panel.find('#statisticsList_view_btn').parent('td').next().remove();
                panel.find('#statisticsList_view_btn, #statisticsList_view_btn + hr', panel).remove();
                panel.find('#statisticsList_next1').hide();
                panel.find('#statisticsList_next2').show();
                panel.find("#statisticsList_tj_btn").children('span').children('span').eq(0).html("提交")
            } else if(stype ==1){
                panel.find('#statisticsList_view2_btn').parent('td').next().remove();
                panel.find('#statisticsList_view2_btn, #statisticsList_view2_btn + hr', panel).remove();
                panel.find('#statisticsList_next1').show();
                panel.find('#statisticsList_next2').hide();

            }

            //行政区划初始化
            panel.find('#user_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        $('#user_second').combobox('select', list[0]["unitCode"]);
                        panel.find('#user_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                            onLoadSuccess: function (list2) {
                                if(list2 != null && list2.length == 1){
                                    $('#user_third').combobox('select', list2[0]["unitCode"]);
                                    panel.find('#user_fourth').combobox({
                                        url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+list2[0]["unitCode"] ,
                                        valueField: 'unitCode',
                                        textField: 'unitName',
                                        onLoadSuccess: function (list3) {
                                            if(list3 != null && list3.length == 1){
                                                $('#user_fourth').combobox('select', list3[0]["unitCode"]);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#user_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#user_third').combobox('clear');
                    panel.find('#user_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#user_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });
            //行政区划联动
            panel.find('#user_third').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#user_fourth').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#user_fourth').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/4/"+newValue);
                    }
                }
            });




            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isZj = false;
                var isSXj = false;
                var isSj = true;
                var isck = false;//只有查看权限用户
                panel.find("#dqRoleCode").val(rlt[1].roleCode);
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'||rlt[i].roleCode == '0012'||rlt[i].roleCode == '0011'){
                        if(rlt[i].roleCode == '0010'){
                            isSj = false;
                        }
                        isZj = true;
                        break;
                    }
                    if(rlt[i].roleCode == '0013'){
                        isSXj = true;
                        break;
                    }

                    if(rlt[i].roleCode == '0015'){
                        isck = true;
                    }

                }
                if(isZj){
                    panel.find('#statisticsList_cxdr_btn').parent('td').next().remove();
                    panel.find('#statisticsList_cxdr_btn, #statisticsList_cxdr_btn + hr', panel).remove();
                    panel.find('#statisticsList_tj_btn').parent('td').next().remove();
                    panel.find('#statisticsList_tj_btn, #statisticsList_tj_btn + hr', panel).remove();
                    panel.find('#statisticsList_rqsj_btn').parent('td').next().remove();
                    panel.find('#statisticsList_rqsj_btn, #statisticsList_rqsj_btn + hr', panel).remove();
                    panel.find('#farmhousejbxx_add_btn').parent('td').next().remove();
                    panel.find('#farmhousejbxx_add_btn, #farmhousejbxx_add_btn + hr', panel).remove();
                }
                if(isSXj){
                    panel.find('#statisticsList_sl_btn').parent('td').next().remove();
                    panel.find('#statisticsList_sl_btn, #statisticsList_sl_btn + hr', panel).remove();
                    panel.find('#statisticsList_th_btn').parent('td').next().remove();
                    panel.find('#statisticsList_th_btn, #statisticsList_th_btn + hr', panel).remove();
                } else {//非镇级去掉上一步下一步
                    panel.find(".cy-btn-position").hide();
                }
                if(isSj){
                    $("#statisticsList_gs_btn").css("display","none")
                }
                if(isck){
                    panel.find('#farmhousejbxx_add_btn').parent('td').next().remove();
                    panel.find('#farmhousejbxx_add_btn, #farmhousejbxx_add_btn + hr', panel).remove();

                    panel.find('#statisticsList_view_btn').parent('td').next().remove();
                    panel.find('#statisticsList_view_btn, #statisticsList_view_btn + hr', panel).remove();

                    panel.find('#statisticsList_view2_btn').parent('td').next().remove();
                    panel.find('#statisticsList_view2_btn, #statisticsList_view2_btn + hr', panel).remove();

                    panel.find('#statisticsList_tj_btn').parent('td').next().remove();
                    panel.find('#statisticsList_tj_btn, #statisticsList_tj_btn + hr', panel).remove();

                    panel.find('#statisticsList_sl_btn').parent('td').next().remove();
                    panel.find('#statisticsList_sl_btn, #statisticsList_sl_btn + hr', panel).remove();

                    panel.find('#statisticsList_th_btn').parent('td').next().remove();
                    panel.find('#statisticsList_th_btn, #statisticsList_th_btn + hr', panel).remove();

                    panel.find('#statisticsList_exp_btn').parent('td').next().remove();
                    panel.find('#statisticsList_exp_btn, #statisticsList_exp_btn + hr', panel).remove();

                    panel.find('#statisticsList_gs_btn').parent('td').next().remove();
                    panel.find('#statisticsList_gs_btn, #statisticsList_gs_btn + hr', panel).remove();

                }
            });
            panel.off('click', '#statisticsList_a_lct');
            panel.on('click', '#statisticsList_a_lct', function () {
                window.open("../../templatefile/信息统计流程图.jpg");
            });
        };

    });

    return StatisticsList;
});

