define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    var VillagejbxxAdd = Page.extend(function () {
        var _self;
        // @override
        this.load = function (panel, data) {
            _self = this;

            var form = panel.find('form');
            form.form('disableValidation')
                .form('focus');

            //获取登录用户行政区划信息
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (rlt) {
                if(rlt != null ){
                    panel.find("#districtcode").val(rlt.countyCode);
                    panel.find("#town").val(rlt.townCode);
                    panel.find("#statisticsList_xzqh_div").html(rlt.district);
                }
            });

            // 行政村、自然村联动
            /*panel.find('#statisticsList_administrativevillage').combobox({
                onChange: function (newValue, oldValue) {
                    if (newValue != null){
                        panel.find('#statisticsList_vid').combobox("clear");
                        panel.find('#statisticsList_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
                    }
                }
            });*/


        };

        // @override
        this.submit = function (panel, data, closeCallback) {
            var form = panel.find('form');


            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');

            if (isValid) {
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/common/statisticsList',
                        method: 'post',
                    }).then(closeCallback);
            }

            return false;
        };

        // @override
        this.onClose = function (table, data) {
            table.datagrid('reload');
        };
    });

    return VillagejbxxAdd;
});