define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');

    // 业务信息
    var Phonefxyuyj = Page.extend(function () {
        // @override
        this.load = function (panel) {
            var table = this.table = panel.find('table');
            this.$autoHeight('north', $('#phonefxyuyj-info-main', panel));
            var date = new Date();
            var year = date.getFullYear();
            $("#phonefxyuyj_year").combobox("setValue", year);
            var url = "service/sjcj/phonefxyuyj?s_time=" + panel.find("#phonefxyuyj_year").combobox("getValue");

            table.cdatagrid({
                controller: this,
                url: url
            });
            //第一次加载
            panel.find('#phonefirst').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoFirst",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    /*if (da["yhjb"] == "fsj") {*/
                    $('#phonefirst').combobox('select', da["unitCode"]);
                    $("#phonefirst").combobox('readonly', true);
                    /*  }*/
                }
            });
            panel.find('#phonesecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#phonesecond').combobox('select', da["unitCode"]);
                            $("#phonesecond").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#phonethird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#phonethird').combobox('select', da["unitCode"]);
                            $("#phonethird").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#phonefirst').combobox({
                onChange: function() {
                    var code = panel.find('#phonefirst').combobox('getValue');
                    panel.find('#phonesecond').combobox('clear');
                    // 重新获取数据
                    panel.find('#phonesecond').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfoSecond?code=' + code);
                }
            });
            panel.find('#phonesecond').combobox({
                onChange: function() {
                    var code = panel.find('#phonesecond').combobox('getValue');
                    panel.find('#phonethird').combobox('clear');
                    // 重新获取数据
                    panel.find('#phonethird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
        };

    });
    this.warningformat1 = function (value) {
        var hids = '';
        for (var i = 0; i < $(value).length; i++) {
            hids = hids + $(value)[i];
            if (i != $(value).length - 1) {
                hids = hids + ',';
            }
        }
        var size = $(value).length;
        var content = '';
        if (size != undefined && size != 0) {
            content = '<a  href="#" style="color:red;"  onclick="openSfxx(\'' + hids + '\')" >' + $(value).length + '</a>';
        } else {
            content = '0';
        }
        return content;
    }
    this.warningformat2 = function (value) {
        var content = '';
        if (value != undefined && value != '0.00') {
            content = '<span style="color:red;">' + value + '%</span>';
        } else {
            content = '<span > 0.00% </span>';
        }
        return content;
    }

    this.openSfxx = function (hids) {
        if (hids.trim() != '')
            var title = "手机号错误信息";
        var url = 'modules/sjcj/householdregisterjbxx/householdregisterjbxx.jsp?hids=' + hids;
        var buttons = [{method: 'onClose', text: '关闭'}];
        var dialogId = "_sfzcwxx";
        Dialog.open({
            id: dialogId,
            title: title,
            href: url,
            width: 1250,
            height: 600,
            buttons: buttons
        });

    }

    return Phonefxyuyj;
});