define(function(require){

    var Config = require('config');
    var Page = require('core/page');
    var Core = require('core/core');
    var ajaxSubmit = require('plugins/jquery.form');

    var NoticeAdd=Page.extend(function(){
        var _self = this;
        this.load = function (panel, data) {
            var form = panel.find('form');

            form.form('disableValidation')
                .form('focus');

            //实例化编辑器
            //建议使用工厂方法getEditor创建和引用编辑器实例，如果在某个闭包下引用该编辑器，直接调用UE.getEditor('editor')就能拿到相关的实例
            UE.delEditor("ncontent");//在页面每次初始化的时候，先删除掉以前的编辑器，再次进行初始化。否则会出现第二次渲染失败
            var ue = UE.getEditor('ncontent',{
                toolbars: [['undo','redo','|','bold','italic','|', 'fontfamily', 'fontsize','|','forecolor','|','rowspacingtop', 'rowspacingbottom', 'lineheight','|',
                    'justifyleft', 'justifycenter', 'justifyright', 'justifyjustify','|', 'insertimage']],
                enableAutoSave: false,
                autoHeightEnabled: false,
                autoClearinitialContent: true,
                initialFrameHeight: 300,
                wordCount: false,
                elementPathEnabled: false,
                initialFrameWidth: 880,
                imagePopup:true,
                saveInterval:0,
                autosave:false,
                imageScaleEnabled: false,//去除拉伸边框
                imagePopup: false,//关闭图片悬浮工具栏
              /*  enterTag : 'br',*/

            });

        };
        this.submit=function(panel, data, closeCallback){
            var form = panel.find('form');
            form.form('enableValidation');
            var isValid = form.form('validate');
            var notice_form = _self.panel.find('#notice_form');
            var str=UE.getEditor('ncontent').getContent().replace(/&nbsp;/g,"\T").replace(/&quot;/g,"\Z");
             var ues=UE.getEditor('ncontent');
            ues.ready(function() {
                ues.setContent(str);
            });
            var fileName = panel.find("#tg_fj").val();
            fileName = fileName.replace('C:\\fakepath\\','');
            if(isValid){
                form.form('ajax', {
                    url: Config.ContextPath + 'service/sjcj/notice?type=new',
                    method: 'post'
                }).then(function(rlt,notice){
                    if(rlt.isOk){
                        var eid=rlt.notice.nid;
                        panel.find("#notice_form").ajaxSubmit({
                            url:Config.ContextPath+'service/attachment/uploadfj?fileName='+fileName+'&eid='+eid+'&types=6',
                            type:'post',
                            error :function() {
                                $.messager.alert('警告','附件上传失败！','warning');
                            }
                        });

                        $.messager.alert('提醒', '公告信息保存成功！');
                        closeCallback();
                    } else{
                        $.messager.alert('提醒', '公告信息保存失败，原因：'+rlt.msg ,'warning');
                        return  false;
                    }
                });
            }
            return false;
        };

        this.onClose = function(table, data) {
            table.datagrid('reload');
            if(typeof(UE.getEditor("ncontent")) !='undefined'){
                UE.getEditor("ncontent").destroy();
            }
        };


    });

    return NoticeAdd;
});