define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    var Events = require('core/events');

    var NewhousingjbxxView = require('./newhousingjbxx.view');
    var NewhousingjbxxExp = require('./newhousingjbxx.exp');

    var Newhousingjbxx = Page.extend(function () {
        this.injecte([
            new NewhousingjbxxView('newhousingjbxx_view'),
            new NewhousingjbxxExp('newhousingjbxx_exp'),

        ]);

        // @override
        this.load = function (panel, fid,vid) {//vid自然村id，下一步时参数携带
            var table = this.table = panel.find('table');
            this.$autoHeight('north', $('#newHousing-info-main', panel));
            var url = "service/sjcj/newhousingjbxx/listTJ";
            if(fid != null && fid != '' && fid != 'null'){
                panel.find("#newhouse_s_fid").val(fid);
                url += '?fid='+fid;
            }else{
                $('#p_newhousingid, #p_newhousingid + hr', panel).remove();
            }
            if(vid != null && vid != ""){
              panel.find("#newhouse_vid").val(vid);
            }
            table.cdatagrid({
                controller: this,
                url: url,
                pageList:[10,20,50,100,500],
            });

            //根据权限设置操作按钮:镇、县区和市都可以增加、修改、删除、导入
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isck = false;//仅有查看功能
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0015'){
                        isck = true;
                    }
                }
                if(isck){
                    $("#newhousingjbxx_exp_btn").parent("td").next().remove();
                    $('#newhousingjbxx_exp_btn, #newhousingjbxx_exp_btn + hr', panel).remove();
                }
            });


            //第一次加载
            panel.find('#first').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoFirst",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    $('#first').combobox('select', da["unitCode"]);
                    $("#first").combobox('readonly', true);

                }
            });

            panel.find('#second').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#second').combobox('select', da["unitCode"]);
                            $("#second").combobox('readonly', true);
                        }
                    }

                }
            });

            panel.find('#third').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#third').combobox('select', da["unitCode"]);
                            $("#third").combobox('readonly', true);
                        }
                    }

                }
            });

            panel.find('#fourth').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfofourth",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#fourth').combobox('select', da["unitCode"]);
                            $("#fourth").combobox('readonly', true);
                        }
                    }

                }
            });

            panel.find('#first').combobox({
                onChange: function() {
                    var code = panel.find('#first').combobox('getValue');
                    panel.find('#second').combobox('clear');
                    // 重新获取数据
                    panel.find('#second').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfoSecond?code=' + code);
                }
            });
            panel.find('#second').combobox({
                onChange: function() {
                    var code = panel.find('#second').combobox('getValue');
                    panel.find('#third').combobox('clear');
                    // 重新获取数据
                    panel.find('#third').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
            panel.find('#third').combobox({
                onChange: function() {
                    var code = panel.find('#third').combobox('getValue');
                    panel.find('#fourth').combobox('clear');
                    // 重新获取数据
                    panel.find('#fourth').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfofourth?code=' + code);
                }
            });

        };

    });

    return Newhousingjbxx;
});
