define(function(require) {
    var Config = require('config');
    var Page = require('core/page');
    var Core = require('core/core');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');


    var NewhousingjbxxImp = Page.extend(function() {
        var _self = this;
        var _data;
        // @override
        this.load = function(panel, data) {
            _data = data;
            var form = panel.find('form');
            form.form('disableValidation');
            var fid = this.parent.panel.find("#newhouse_s_fid").val();
            // 行政村、自然村联动
            panel.find('#newhousingjbxx_administrativevillage').combobox({
                onChange: function (newValue, oldValue) {
                    if (newValue != null){
                        panel.find('#newhousingjbxx_vid').combobox("clear");
                        panel.find('#newhousingjbxx_vid').combobox('reload', Config.ContextPath + 'service/sjcj/villagejbxx/list2?administrativevillage=' + newValue);
                    }
                }
            });
            $("#newhousing_imp_btn").click(function() {
                var form = panel.find('form');
                form.form('enableValidation');
                var isValid = form.form('validate');
                var administrativevillage = panel.find("#newhousingjbxx_administrativevillage").val();
                if(administrativevillage==''||administrativevillage==null ||administrativevillage==undefined){
                    $.messager.alert('警告', '请先选择行政村', 'warning');
                    return false;
                }
                //中心点，若页面选择了自然村则返回自然村经纬度，若自然村为空行政村不为空，则返回行政村经纬度，若均未选，返回登录用户行政区划经纬度
                var url = Config.ContextPath;
                var vid = _self.panel.find("#newhousingjbxx_vid").val();
                if(vid != null && vid.length > 0){
                    url += "service/sjcj/villagejbxx/" + vid;
                } else {
                    url += "system/unitinfo/" + administrativevillage;
                }
                Core.ajax(url, {
                    type: 'json',
                    method: 'get'
                }).then(function(rlt) {
                    var unitManager = rlt.unitManager;
                    if (unitManager != null) {
                        var temp = unitManager.split(',');
                        lng = temp[0];
                        lat = temp[1];
                    } else {
                        lng = rlt.longit;
                        lat = rlt.lat;
                    }
                    panel.find("#lat").val(lat);
                    panel.find("#longit").val(lng);
                    if (isValid) {
                        $("#newhousingjbxx_imp_form").ajaxSubmit({
                            url: Config.ContextPath + 'service/sjcj/newhousingjbxx/imp',
                            type: 'post',
                            data: {
                                "fid" : fid
                            },
                            error: function () {
                                $.messager.alert('警告', '导入失败！', 'warning');
                            },
                            success: function (rlt) {
                                if (rlt.code == 0) {
                                    $("#succ_div").html(rlt.data.succCnt);

                                    var failedHtml = '共' + rlt.data.failedArr.length + '条<br>';
                                    $.each(rlt.data.failedArr, function (index, item) {
                                        failedHtml += ' 行号:' + item.rowNo;
                                        failedHtml += ' &nbsp;&nbsp;失败原因:【' + item.colName + '】';
                                        if (item.value != null && !item.value == '') {
                                            failedHtml += '("' + item.value + '") ';
                                        }
                                        failedHtml += item.errMsg;
                                        if (item.validValue != null && !item.validValue == '') {
                                            failedHtml += ' &nbsp;&nbsp;可选值 [' + item.validValue + ']';
                                        }
                                        failedHtml += '<br>';
                                    });
                                    $("#fail_div").html(failedHtml);
                                } else {
                                    $.messager.alert('警告', rlt.message, 'warning');
                                }
                            }
                        });
                    }
                });




            });
        };

        // @override
        this.submit = function(panel, data, closeCallback) {
            closeCallback();
            return false;
        };

        // @override
        this.onClose = function(table, data) {
            table.datagrid('reload');
        };
    });

    return NewhousingjbxxImp;
});