<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
    <style type="text/css">
        body, html,#allmap {width: 100%;height: 100%;overflow: hidden;margin:0;font-family:"微软雅黑";}
    </style>
    <script type="text/javascript" src="https://api.map.baidu.com/api?v=3.0&ak=caPIEgAVrCIG8cZRMlHEWz8bGybVQz24&s=1"></script>
    <script type="text/javascript" src="https://api.map.baidu.com/library/Heatmap/2.0/src/Heatmap_min.js"></script>
<%--    <script type="text/javascript" src="../../../ui/js/jquery/jquery-1.11.2.min.js"></script>--%>
    <title>地图展示</title>
</head>

<style>
    /*!*版权隐藏*!
    .BMap_cpyCtrl {
        display:none;
    }

    !*logo隐藏*!
    .anchorBL{
        display:none;
    }*/
</style>

<body>
    <div id="allmap"></div>
</body>

<script type="text/javascript">
    var lastChoosePoint = null;

    var locPointMarker = null; // 定位点
    var boundaryOverlay = new Array(); // 行政区划边界范围
    var labelArray = new Array(); // 户数文本标记
    var heatmapOverlay; // 热力图图层
    var isShowHeat = false;

    var myGeo; //地址解析服务
    var map;

    initMap();

    function initMap() {
        // 百度地图API功能
        map = new BMap.Map("allmap", {enableMapClick: false});    // 创建Map实例,关闭默认的POI点击事件
        map.centerAndZoom(new BMap.Point(119.904, 32.981), 8);  // 初始化地图,设置中心点坐标和地图级别  江苏省

        //添加地图类型控件 普通、混合
        map.addControl(new BMap.MapTypeControl({
            mapTypes: [
                BMAP_NORMAL_MAP,
                BMAP_HYBRID_MAP
            ]
        }));
        map.enableScrollWheelZoom(true);     //开启鼠标滚轮缩放
        map.addControl(new BMap.ScaleControl({anchor: BMAP_ANCHOR_BOTTOM_LEFT})); // 左下角，添加比例尺

        heatmapOverlay = new BMapLib.HeatmapOverlay({"radius": 20}); // 热力图图层
        myGeo = new BMap.Geocoder(); //地址解析服务
    }

    // 根据ip定位城市
    function localCityByIp(){
        var myCity = new BMap.LocalCity();
        myCity.get(function(result){
            panToCity(result.name);
        });
    }

    // 移动并缩放到指定城市
    function panToCity(name){
        map.centerAndZoom(name, 10);
    }

    // 移动并缩放到指定乡镇
    function panToTown(lng, lat) {
        map.centerAndZoom(new BMap.Point(lng, lat), 12);
    }

    // 添加定位标注点
    function addPoint(lng, lat) {
        if(locPointMarker != null) {
            map.removeOverlay(locPointMarker); //清除覆盖物
        }
        var point = new BMap.Point(lng, lat);
        locPointMarker = new BMap.Marker(point); // 创建点
        var label = new BMap.Label("经度:" + lng + "   纬度:" + lat, {offset:new BMap.Size(20,-10)});
        locPointMarker.setLabel(label);
        map.addOverlay(locPointMarker); //增加点

        lastChoosePoint = point;
    }

    // 添加选择定位点的点击事件监听
    function openChoosePointClickListener() {
        map.addEventListener("click", clickHandler); // 点击事件
    }
    function clickHandler(e){
        addPoint(e.point.lng.toFixed(6), e.point.lat.toFixed(6));
    }

    // 清除边界覆盖物
    function clearBoundary() {
        if(boundaryOverlay != null) {
            for(var i = 0; i < boundaryOverlay.length; i++) {
                map.removeOverlay(boundaryOverlay[i]); //清除地图覆盖物
            }
        }
    }

    // 清除标签覆盖物
    function clearLabel() {
        if(labelArray != null) {
            for(var i = 0; i < labelArray.length; i++) {
                map.removeOverlay(labelArray[i]); //清除地图覆盖物
            }
        }
    }

    // 查询行政区划并标示范围域
    function markBoundary(name) {
        if(name != null && name != undefined && name != '' && name != 'undefined') {
            var bdary = new BMap.Boundary();
            bdary.get(name, function (rs) {       //获取行政区域
                clearBoundary();
                var count = rs.boundaries.length; //行政区域的点有多少个
                if (count === 0) {
                    alert('未能获取当前选择的行政区域:' + name);
                    return;
                }
                var pointArray = [];
                for (var i = 0; i < count; i++) {
                    var ply = new BMap.Polygon(rs.boundaries[i], {
                        strokeWeight: 2,
                        strokeColor: "#1a68f9",
                        strokeOpacity: 0.9,
                        fillColor: "#1a68f9",
                        fillOpacity: 0.06
                    }); //建立多边形覆盖物
                    boundaryOverlay[i] = ply;
                    map.addOverlay(ply);  //添加覆盖物
                    pointArray = pointArray.concat(ply.getPath());
                }
                map.setViewport(pointArray);    //调整视野
            });
        }
    }

    // 标注首页农户数
    function markHouseCount(data, xzqh) {
        clearLabel();
        var pointArray = new Array();
        var isVillage = false;
        for (var i = 0; i < data.length; i++) {
            var item = data[i];
            if (item.lng != null && item.lng != '' && item.lat != null && item.lat != '') {
                var lng = item.lng;
                var lat = item.lat;
                var point = new BMap.Point(lng, lat);
                var nameLength = item.name.length > 3 ? item.name.length : 3;
                var offWidth = nameLength * 6 + 15;
                pointArray[pointArray.length] = point;
                var opts = {
                    position: point,    // 指定文本标注所在的地理位置
                    offset: new BMap.Size(-offWidth, -52)    //设置文本偏移量
                };
                var label = new BMap.Label('<div style="margin:9px;margin-top:2px;text-align:center">' + item.name + '<br>' + item.count + '户<div>', opts);  // 创建文本标注对象
                label.setStyle({
                    color: "white",
                    fontSize: "14px",
                    height: "52px",
                    width: offWidth*2 + "px",
                    background: "url('img/labelbg.png')",
                    backgroundSize: '100% 100%',
                    border: "1"
                });
                label.unitcode = item.unitcode;
                label.vid = item.vid;
                if(item.vid != null && item.vid != undefined && item.vid != '') {
                    isVillage = true;
                }
                label.name = item.name;
                label.addEventListener("click", toFarmhouseList);
                labelArray[labelArray.length] = label;
                map.addOverlay(label);
            }
        }
        if(isVillage) {
            map.setViewport(pointArray); // 可视区域移动缩放到显示所有点
        }
    }

    // 绘制热力图
    function drawHeatMap(data) {
        map.removeOverlay(heatmapOverlay);
        heatmapOverlay = new BMapLib.HeatmapOverlay({"radius": 6});
        map.addOverlay(heatmapOverlay);
        heatmapOverlay.setDataSet({data: data, max: 20});
        if(isShowHeat) {
            heatmapOverlay.show();
        } else {
            heatmapOverlay.hide();
        }
    }

    // 显示热力图
    function showHeatMap() {
        heatmapOverlay.show();
        isShowHeat = true;
    }

    // 隐藏热力图
    function hideHeatMap() {
        heatmapOverlay.hide();
        isShowHeat = false;
    }

    // 跳转到列表
    function toFarmhouseList(e){
        parent.HomePage.toFarmhouseList(e.target.vid, e.target.unitcode, e.target.name);
    }
</script>
