<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true" id="statistics-info-main2">
    <div region="north" border="false" style="height: 60px; padding: 4px;">
        <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
            <form class="clearFromValue" >
                <input type="hidden" name = "userRole" id="userRole">
                <input type="hidden" name = "userCode" id="userCode">
                <div class="search-item">
                    <label>统计年份(多选)</label>
                    <input type="text" class="easyui-combobox" name="year" style="width: 200px" id="tableListYear"
                           url="service/common/getYearList/10" method="get"
                           data-options="valueField:'year',textField:'year',multiple:true"/>
                </div>
                <div class="search-item">
                    <label>城市</label>
                <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="second" id="user_second" method="get" prompt="全省"/>
                </div>
                <button  type="button"class="easyui-linkbutton btn-search" iconCls="icon-search" id="tableListSearch">搜索</button>
                <button  type="button"class="easyui-linkbutton btn-search"  id="tableListSave" style="width: 60px">保存</button>
                <%--<a class="easyui-linkbutton btn-search" iconCls="icon-search"><p id="e@btn.search">搜索</p></a>--%>
            </form>
        </div>
    </div>

    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <table style="width:100%; height:90%" rownumbers="false" id="tableList_zkl" idField="id"
               search=".search" layoutH=".search" toolbar=".temp-toolbar"  pagination="false" >
            <thead>
            <tr>
                <th data-options="field:'city',align:'center'" rowspan="2">设区市</th>
                <th data-options="field:'sjbm',align:'center'" rowspan="2">县（市、区）</th>
                <th data-options="field:'target',align:'center',formatter:ccformat10" rowspan="2" >省定各市目标任务<br/>及各市分解至<br/>县市区数量（户）</th>
                <th colspan="9">省定目标任务完成情况</th>
                <th colspan="5">各地计划新建项目</th>
            </tr>
            <tr>
                <th data-options="field:'totalNumber',align:'center'">实际完成<br/>总数（户）</th>
                <th data-options="field:'targetFinishNumber',align:'center'">其中：对<br/>应省定任务<br/>完成数<br/>（户）</th>
                <th data-options="field:'overHouse',align:'center'">其中：推<br/>动农户自行<br/>改善数<br/>（户）</th>
                <th data-options="field:'finishProportion',align:'center'">完成总数与<br/>目标任务数<br/>的占比（%）</th>
                <th data-options="field:'buyHouse',align:'center',formatter:ccformat1">进城购房<br/>改善（户）</th>
                <th data-options="field:'buyvillages',align:'center',formatter:ccformat2">入镇购房<br/>改善（户）</th>
                <th data-options="field:'newHouse',align:'center',formatter:ccformat3">新型农村<br/>社区改善（户）</th>
                <th data-options="field:'temporaryHouse',align:'center',formatter:ccformat4">城镇集中<br/>安置区<br/>改善（户）</th>
                <th data-options="field:'overHouse2',align:'center',formatter:ccformat5">规划发展<br/>村庄就地<br/>新建翻建<br/>改善（户）</th>
                <th data-options="field:'proNumbers',align:'center'">项目总数<br/>（个）</th>
                <th data-options="field:'improveNumbers',align:'center',formatter:ccformat6">其中：城镇改<br/>善项目（个）</th>
                <th data-options="field:'cityImproveNumbers',align:'center',formatter:ccformat7">其中：乡村改<br/>善项目（个）</th>
                <th data-options="field:'startsNumbers',align:'center',formatter:ccformat8">已开工<br/>项目（个）</th>
                <th data-options="field:'finishNumbers',align:'center',formatter:ccformat9">已竣工<br/>项目（个）</th>
            </tr>
            </thead>
        </table>
        <div class="temp-toolbar">
            <a iconCls="icon-redo" trigger="none" target="custom"  rel="table_exp" id="table_exp_btn">导出</a>
            <hr>
        </div>
    </div>
</div>
<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'modules/sjcj/jhgsWorkZkl/ctrl/tableList'
        ], function (TableList) {
            window.TableList = new TableList('tableList', panel);
            window.TableList.load(panel);
        });

    };
</script>