define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var $ = require('jquery');

    var housemoneyDeatil = Page.extend(function() {
        var _self;

        // @override
        this.load = function(panel,data) {
            _self = this;
            _self.data = data.objValue;
            var fyear = _self.data.fyear;
            var ftype = _self.data.ftype;
            var countycode = _self.data.countycode;
            Core.ajax(Config.ContextPath+'service/sjcj/zklinfo/'+fyear+'/'+ftype+'/'+countycode, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                if(data.newval !=undefined){
                    _self.data.newval = data.newval;
                    _self.data.zkl = data.zkl;
                    _self.data.oldval = data.oldval;
                }
                var form = panel.find('#tableList_zkl');
                form.form('load', _self.data);
            });


        };



        // @override
        this.onSubmit = function(panel,data,closeCallback) {
            var form = panel.find('form');
            var obj = form.form("value");
            if( obj.zkl == ''  && obj.newval == '' ){
                $.messager.alert('提醒', '折扣率和现值必须选填一个', 'warning');
                return false;
            }
            if(parseFloat(obj.zkl)>1 || parseFloat(obj.zkl)<-1){
                $.messager.alert('提醒', '折现率做范围在-1~1之间', 'warning');
                return false;
            }
            form.form('ajax', {
                url: Config.ContextPath + 'service/sjcj/zklinfo',
                method: 'post'
            }).then(function() {
                 _self.parent.panel.find("#tableList_zkl").datagrid("reload");
                closeCallback();
            });
            return  false;

        };



    });

    return housemoneyDeatil;
});