define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    // 业务信息
    var _self;
    var JhgsWorkByPersonListExp = require('./jhgsWorkByPersonList.exp');
    var JhgsWorkByPersonList = Page.extend(function() {
        this.injecte([
            new JhgsWorkByPersonListExp('jhgsworkByPersonList_exp'),
        ]);
        var _self = this;

        this.load = function(panel) {
            var date = new Date;
            var table = this.table = panel.find('table');
            table.cdatagrid({
                controller: this
            });
            panel.find('#pfyear').combobox({
                url: Config.ContextPath + "service/common/getYearList/10",
                valueField: 'year',
                textField: 'year',
                onLoadSuccess: function (data) {
                    var data = $('#pfyear').combobox('getData');//获取所有下拉框数据
                    if (data.length > 0) {
                        $('#pfyear').combobox('select',data[0].year);
                    }
                    var fyear1 = $("#pfyear").val();
                    table.cdatagrid({
                        controller: this,
                        url : Config.ContextPath + "service/jhgswork/jhgsworkListByPersonType?fyear="+fyear1
                    });
                }
            });
            //第一次加载
            panel.find('#pfirst').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoFirst",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    /*if (da["yhjb"] == "fsj") {*/
                        $('#pfirst').combobox('select', da["unitCode"]);
                        $("#pfirst").combobox('readonly', true);
                  /*  }*/
                }
            });
            panel.find('#psecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#psecond').combobox('select', da["unitCode"]);
                            $("#psecond").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#pthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#pthird').combobox('select', da["unitCode"]);
                            $("#pthird").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#pfourth').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfofourth",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            $('#pfourth').combobox('select', da["unitCode"]);
                            $("#pfourth").combobox('readonly', true);
                        }
                    }

                }
            });
            panel.find('#pfirst').combobox({
                onChange: function() {
                    var code = panel.find('#pfirst').combobox('getValue');
                    panel.find('#psecond').combobox('clear');
                    // 重新获取数据
                    panel.find('#psecond').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfoSecond?code=' + code);
                }
            });
            panel.find('#psecond').combobox({
                onChange: function() {
                    var code = panel.find('#psecond').combobox('getValue');
                    panel.find('#pthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#pthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
            panel.find('#pthird').combobox({
                onChange: function() {
                    var code = panel.find('#pthird').combobox('getValue');
                    panel.find('#pfourth').combobox('clear');
                    // 重新获取数据
                    panel.find('#pfourth').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfofourth?code=' + code);
                }
            });
            //查询
            panel.find('#planCxp').click(function() {
                var fyear = $("#pfyear").val();
                var first = $("#pfirst").val();
                var second = $("#psecond").val();
                var third = $("#pthird").val();
                var fourth = $("#pfourth").val();
                var params = "";
                params =  "&fyear=" + encodeURI(encodeURI(fyear))+"&first="+encodeURI(encodeURI(first))+"&second="+second+"&third="+third+"&fourth="+fourth;
                if(params != ""){
                    params = params.substring(1,params.length);
                }
                table.cdatagrid({
                    controller: this,
                    url : Config.ContextPath + "service/jhgswork/jhgsworkListByPersonType?" + params ,
                });
            });


        };
    });

    return JhgsWorkByPersonList;
});